/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;

public class AppSignatureHelper
extends ContextWrapper {
    public static final String TAG = AppSignatureHelper.class.getSimpleName();
    private static final String HASH_TYPE = "SHA-256";
    public static final int NUM_HASHED_BYTES = 9;
    public static final int NUM_BASE64_CHAR = 11;

    public AppSignatureHelper(Context context) {
        super(context);
    }

    public ArrayList<String> getAppSignatures() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = this.getPackageName();
            Signature[] signatureArray = this.getPackageManager();
            signatureArray = signatureArray.getPackageInfo((String)string, (int)64).signatures;
            for (Object object : signatureArray.getPackageInfo((String)string, (int)64).signatures) {
                if ((object = AppSignatureHelper.hash(string, object.toCharsString())) == null) continue;
                arrayList.add(String.format("%s", object));
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"Unable to find package to obtain hash.", (Throwable)nameNotFoundException);
        }
        return arrayList;
    }

    private static String hash(String string, String object) {
        object = string + " " + (String)object;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_TYPE);
            messageDigest.update(((String)object).getBytes(StandardCharsets.UTF_8));
            byte[] byArray = messageDigest.digest();
            object = byArray;
            byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 9);
            object = byArray2;
            object = Base64.encodeToString((byte[])byArray2, (int)3);
            object = ((String)object).substring(0, 11);
            Log.d((String)TAG, (String)String.format("pkg: %s -- hash: %s", string, object));
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.e((String)TAG, (String)"hash:NoSuchAlgorithm", (Throwable)noSuchAlgorithmException);
            return null;
        }
    }
}

