/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.Status;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import java.util.Objects;

public class AutoReadOtpHelper
extends BroadcastReceiver {
    private Activity activity;
    private String packageName;

    public AutoReadOtpHelper(Activity activity) {
        this.activity = activity;
        this.packageName = activity.getPackageName();
    }

    public void onReceive(Context context, Intent intent) {
        if ("com.google.android.gms.auth.api.phone.SMS_RETRIEVED".equals(intent.getAction())) {
            Bundle bundle = intent.getExtras();
            Status status = null;
            if (bundle != null) {
                status = (Status)bundle.get("com.google.android.gms.auth.api.phone.EXTRA_STATUS");
            }
            AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_RECEIVED_SMS);
            if (status != null) {
                switch (status.getStatusCode()) {
                    case 0: {
                        if (this.activity.getCallingActivity() == null || !Objects.requireNonNull(this.activity.getCallingActivity()).getPackageName().equalsIgnoreCase(this.packageName)) break;
                        Intent intent2 = (Intent)bundle.getParcelable("com.google.android.gms.auth.api.phone.EXTRA_CONSENT_INTENT");
                        try {
                            this.activity.startActivityForResult(intent2, 1001);
                            AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_SHOWED_ONE_TIME_CONSENT);
                        }
                        catch (ActivityNotFoundException activityNotFoundException) {
                            AnalyticsUtil.reportError((Exception)((Object)activityNotFoundException), "critical", activityNotFoundException.getLocalizedMessage());
                            activityNotFoundException.printStackTrace();
                        }
                        break;
                    }
                    case 15: {
                        AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_TIMEOUT);
                    }
                }
            }
        }
    }
}

