/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.util.Base64;
import com.razorpay.AnalyticsUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class CryptLib {
    Cipher _cx = Cipher.getInstance("AES/CBC/PKCS5Padding");
    byte[] _key = new byte[32];
    byte[] _iv = new byte[16];

    CryptLib() throws NoSuchAlgorithmException, NoSuchPaddingException {
    }

    static final String md5(String inputString) {
        String MD5 = "MD5";
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(inputString.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
            return "";
        }
    }

    private String encryptDecrypt(String _inputText, String _encryptionKey, EncryptMode _mode, String _initVector) throws UnsupportedEncodingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        String _out = "";
        int len = _encryptionKey.getBytes("UTF-8").length;
        if (_encryptionKey.getBytes("UTF-8").length > this._key.length) {
            len = this._key.length;
        }
        int ivlen = _initVector.getBytes("UTF-8").length;
        if (_initVector.getBytes("UTF-8").length > this._iv.length) {
            ivlen = this._iv.length;
        }
        System.arraycopy(_encryptionKey.getBytes("UTF-8"), 0, this._key, 0, len);
        System.arraycopy(_initVector.getBytes("UTF-8"), 0, this._iv, 0, ivlen);
        SecretKeySpec keySpec = new SecretKeySpec(this._key, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(this._iv);
        if (_mode.equals((Object)EncryptMode.ENCRYPT)) {
            this._cx.init(1, (Key)keySpec, ivSpec);
            byte[] results = this._cx.doFinal(_inputText.getBytes("UTF-8"));
            _out = Base64.encodeToString((byte[])results, (int)2);
        }
        if (_mode.equals((Object)EncryptMode.DECRYPT)) {
            this._cx.init(2, (Key)keySpec, ivSpec);
            byte[] decodedValue = Base64.decode((byte[])_inputText.getBytes(), (int)2);
            byte[] decryptedVal = this._cx.doFinal(decodedValue);
            _out = new String(decryptedVal);
        }
        return _out;
    }

    static String SHA256(String text, int length) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(text.getBytes("UTF-8"));
        byte[] digest = md.digest();
        StringBuffer result = new StringBuffer();
        for (byte b : digest) {
            result.append(String.format("%02x", b));
        }
        String resultStr = length > result.toString().length() ? result.toString() : result.toString().substring(0, length);
        return resultStr;
    }

    String encrypt(String _plainText, String _key, String _iv) throws InvalidKeyException, UnsupportedEncodingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.encryptDecrypt(_plainText, _key, EncryptMode.ENCRYPT, _iv);
    }

    String decrypt(String _encryptedText, String _key, String _iv) throws InvalidKeyException, UnsupportedEncodingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return this.encryptDecrypt(_encryptedText, _key, EncryptMode.DECRYPT, _iv);
    }

    static String generateRandomIV(int length) {
        SecureRandom ranGen = new SecureRandom();
        byte[] aesKey = new byte[16];
        ranGen.nextBytes(aesKey);
        StringBuffer result = new StringBuffer();
        for (byte b : aesKey) {
            result.append(String.format("%02x", b));
        }
        if (length > result.toString().length()) {
            return result.toString();
        }
        return result.toString().substring(0, length);
    }

    private static enum EncryptMode {
        ENCRYPT,
        DECRYPT;

    }
}

