/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CacheEntry;
import com.razorpay.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class CacheManager {
    static File cacheDir;

    CacheManager() {
    }

    static void init(Context context) {
        cacheDir = context.getCacheDir();
    }

    static boolean hasExpired(String key) {
        File cachedFile = new File(cacheDir.getPath(), key);
        if (!cachedFile.exists()) {
            return true;
        }
        try {
            FileInputStream fis = new FileInputStream(cachedFile);
            ObjectInputStream is = new ObjectInputStream(fis);
            CacheEntry entry = (CacheEntry)is.readObject();
            fis.close();
            is.close();
            if (!CacheManager.hasExpired(entry.expiryTime)) {
                Logger.d("Cache has NOT expired for key " + key);
                return false;
            }
            Logger.d("Cache has expired for key " + key);
            return true;
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
            Logger.e("Error fetching cache entry", e);
            return true;
        }
    }

    private static boolean hasExpired(long expiryTime) {
        return expiryTime <= 0L || System.currentTimeMillis() > expiryTime;
    }

    static void put(String key, String value, long expiryTime) {
        File cachedFile = new File(cacheDir.getPath(), key);
        if (!cachedFile.exists()) {
            try {
                cachedFile.createNewFile();
            }
            catch (IOException e) {
                AnalyticsUtil.reportError(e, "error", e.getMessage());
                Logger.e("Could not store string in cache", e);
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(cachedFile);
            ObjectOutputStream os = new ObjectOutputStream(fos);
            CacheEntry cacheEntry = new CacheEntry(value, expiryTime + System.currentTimeMillis());
            os.writeObject(cacheEntry);
            os.close();
            fos.close();
            Logger.d(String.format("%s stored successfully in cache with expiry time of %d", key, cacheEntry.expiryTime));
            Logger.d("Cache value: " + value);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error", e.getMessage());
            Logger.e("Could not store string in cache", e);
        }
    }

    static void expireKey(String key) {
        CacheManager.put(key, "", -1L);
    }

    static String get(String key) {
        File cachedFile = new File(cacheDir.getPath(), key);
        if (!cachedFile.exists()) {
            Logger.e("Error fetching cache entry.");
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(cachedFile);
            ObjectInputStream is = new ObjectInputStream(fis);
            CacheEntry entry = (CacheEntry)is.readObject();
            fis.close();
            is.close();
            if (CacheManager.hasExpired(entry.expiryTime)) {
                CacheManager.purge(key);
                return null;
            }
            Logger.d(String.format("%s fetched successfully from cache", key));
            Logger.d(entry.data);
            return entry.data;
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
            Logger.e("Error fetching cache entry", e);
            return null;
        }
    }

    static void purge(String key) {
        File cachedFile = new File(cacheDir.getPath(), key);
        cachedFile.delete();
    }
}

