/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;

public class AppSignatureHelper
extends ContextWrapper {
    public static final String TAG = AppSignatureHelper.class.getSimpleName();
    private static final String HASH_TYPE = "SHA-256";
    public static final int NUM_HASHED_BYTES = 9;
    public static final int NUM_BASE64_CHAR = 11;

    public AppSignatureHelper(Context context) {
        super(context);
    }

    public ArrayList<String> getAppSignatures() {
        ArrayList<String> appCodes = new ArrayList<String>();
        try {
            Signature[] signatures;
            String packageName = this.getPackageName();
            PackageManager packageManager = this.getPackageManager();
            for (Signature signature : signatures = packageManager.getPackageInfo((String)packageName, (int)64).signatures) {
                String hash = AppSignatureHelper.hash(packageName, signature.toCharsString());
                if (hash == null) continue;
                appCodes.add(String.format("%s", hash));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Unable to find package to obtain hash.", (Throwable)e);
        }
        return appCodes;
    }

    private static String hash(String packageName, String signature) {
        String appInfo = packageName + " " + signature;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_TYPE);
            messageDigest.update(appInfo.getBytes(StandardCharsets.UTF_8));
            byte[] hashSignature = messageDigest.digest();
            hashSignature = Arrays.copyOfRange(hashSignature, 0, 9);
            String base64Hash = Base64.encodeToString((byte[])hashSignature, (int)3);
            base64Hash = base64Hash.substring(0, 11);
            Log.d((String)TAG, (String)String.format("pkg: %s -- hash: %s", packageName, base64Hash));
            return base64Hash;
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)"hash:NoSuchAlgorithm", (Throwable)e);
            return null;
        }
    }
}

