/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.rollbar.android.RollbarExceptionHandler;
import com.rollbar.android.RollbarThread;
import com.rollbar.android.http.HttpRequestManager;
import com.rollbar.android.http.HttpResponse;
import com.rollbar.android.http.HttpResponseHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Notifier {
    private static int R$$r_ = 0;
    private volatile boolean Q_$2$;
    private final ScheduledExecutorService d__1_ = Executors.newSingleThreadScheduledExecutor();
    private final String G__G_;
    private final String a_$P$;
    private JSONObject b__J_;
    private String B$$W$;
    private boolean r$_Y_;
    private boolean D$_X_;
    private String E$_j$;
    private String Y$_o$;
    private boolean O_$B_;
    private int E$_6$;
    private int l_$w$;
    private String c__C_;
    private final File g__v_;
    private final RollbarThread L__R$;

    public Notifier(Context context, String string2, String string3, boolean bl) {
        this.G__G_ = string2;
        this.a_$P$ = string3;
        try {
            string2 = context.getPackageName();
            string2 = context.getPackageManager().getPackageInfo(string2, 0);
            this.l_$w$ = ((PackageInfo)string2).versionCode;
            this.c__C_ = ((PackageInfo)string2).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"Rollbar", (String)"Error getting package info.");
        }
        this.B$$W$ = "https://api.rollbar.com/api/1/items/";
        this.r$_Y_ = true;
        this.E$_j$ = "warning";
        this.Y$_o$ = "error";
        this.O_$B_ = false;
        this.E$_6$ = 30;
        this.Q_$2$ = false;
        this.g__v_ = new File(context.getCacheDir(), "rollbar-items");
        this.g__v_.mkdirs();
        if (bl) {
            RollbarExceptionHandler.register(this);
        }
        this.L__R$ = new RollbarThread(this);
        this.L__R$.start();
        this.a_$P$(1);
    }

    private static JSONArray Q_$2$() {
        JSONArray jSONArray = null;
        int n = android.os.Process.myPid();
        try {
            String string2;
            Object object = Runtime.getRuntime().exec("logcat -d");
            object = new InputStreamReader(((Process)object).getInputStream());
            object = new BufferedReader((Reader)object, 8192);
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (!string2.contains(String.valueOf(n))) continue;
                arrayList.add(string2);
                if (arrayList.size() <= 100) continue;
                arrayList.remove(0);
            }
            jSONArray = new JSONArray(arrayList);
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to collect logcat info.", (Throwable)iOException);
        }
        return jSONArray;
    }

    private JSONObject d__1_(String object, JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("environment", (Object)this.a_$P$);
        jSONObject2.put("level", object);
        jSONObject2.put("platform", (Object)"android");
        jSONObject2.put("framework", (Object)"android");
        jSONObject2.put("language", (Object)"java");
        jSONObject2.put("body", (Object)jSONObject);
        if (this.b__J_ != null) {
            jSONObject2.put("person", (Object)this.b__J_);
        }
        object = this;
        jSONObject = new JSONObject();
        jSONObject.put("timestamp", System.currentTimeMillis() / 1000L);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("phone_model", (Object)Build.MODEL);
        jSONObject3.put("android_version", (Object)Build.VERSION.RELEASE);
        jSONObject3.put("code_version", (Object)((Notifier)object).c__C_);
        jSONObject3.put("version_code", ((Notifier)object).l_$w$);
        jSONObject3.put("version_name", (Object)((Notifier)object).c__C_);
        if (((Notifier)object).D$_X_) {
            jSONObject3.put("logs", (Object)Notifier.Q_$2$());
        }
        jSONObject.put("android", (Object)jSONObject3);
        jSONObject.put("user_ip", (Object)"$remote_ip");
        jSONObject2.put("client", (Object)jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("name", (Object)"rollbar-android");
        jSONObject.put("version", (Object)"0.2.0");
        jSONObject2.put("notifier", (Object)jSONObject);
        return jSONObject2;
    }

    private static JSONArray d__1_(File file) {
        Log.d((String)"Rollbar", (String)"Loading items...");
        JSONArray jSONArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[1024];
            while (fileInputStream.read(byArray) != -1) {
                stringBuilder.append(new String(byArray));
            }
            fileInputStream.close();
            jSONArray = new JSONArray(stringBuilder.toString());
            Log.d((String)"Rollbar", (String)"Items loaded.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)"Rollbar", (String)"Unable to read item file.", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to read item file.", (Throwable)iOException);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"Invalid item data. Deleting file.", (Throwable)jSONException);
            file.delete();
        }
        return jSONArray;
    }

    public File writeItems(JSONArray jSONArray) {
        Log.d((String)"Rollbar", (String)"Writing items...");
        try {
            Object object = R$$r_++ + "." + System.currentTimeMillis();
            object = new File(this.g__v_, (String)object);
            FileWriter fileWriter = new FileWriter((File)object);
            fileWriter.write(jSONArray.toString());
            fileWriter.close();
            Log.d((String)"Rollbar", (String)"Items written");
            return object;
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to write items.", (Throwable)iOException);
            return null;
        }
    }

    public void postItems(JSONArray jSONArray, File file) {
        Notifier notifier;
        Log.i((String)"Rollbar", (String)"Sending item batch...");
        try {
            JSONArray jSONArray2 = jSONArray;
            notifier = this;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("access_token", (Object)notifier.G__G_);
            jSONObject.put("data", (Object)jSONArray2);
            notifier = jSONObject;
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return;
        }
        HttpRequestManager.getInstance().postJson(this.B$$W$, (JSONObject)notifier, false, new HttpResponseHandler(this, file, jSONArray){
            private /* synthetic */ File G__G_;
            private /* synthetic */ JSONArray a_$P$;
            private /* synthetic */ Notifier d__1_;
            {
                this.d__1_ = notifier;
                this.G__G_ = file;
                this.a_$P$ = jSONArray;
            }

            @Override
            public final void onSuccess(HttpResponse httpResponse) {
                Log.i((String)"Rollbar", (String)"Success");
                if (this.G__G_ != null) {
                    this.G__G_.delete();
                }
            }

            @Override
            public final void onFailure(HttpResponse httpResponse) {
                Log.e((String)"Rollbar", (String)"There was a problem reporting to Rollbar.");
                Log.e((String)"Rollbar", (String)("Response: " + httpResponse));
                if (httpResponse.hasStatusCode() && httpResponse.has4xxStatusCode()) {
                    if (this.G__G_ != null) {
                        this.G__G_.delete();
                        return;
                    }
                } else {
                    if (this.G__G_ == null) {
                        this.d__1_.writeItems(this.a_$P$);
                    }
                    this.d__1_.a_$P$(this.d__1_.E$_6$);
                }
            }
        });
    }

    private void a_$P$(int n) {
        if (!this.Q_$2$) {
            this.Q_$2$ = true;
            Log.d((String)"Rollbar", (String)"Scheduling item file handler...");
            this.d__1_.schedule(new Runnable(this){
                private /* synthetic */ Notifier Q_$2$;
                {
                    this.Q_$2$ = notifier;
                }

                @Override
                public final void run() {
                    Log.d((String)"Rollbar", (String)"Item file handler running...");
                    for (File file : this.Q_$2$.g__v_.listFiles()) {
                        JSONArray jSONArray = Notifier.d__1_(file);
                        this.Q_$2$.postItems(jSONArray, file);
                    }
                    Notifier.Q_$2$(this.Q_$2$);
                    Log.d((String)"Rollbar", (String)"Item file handler finished.");
                }
            }, (long)n, TimeUnit.SECONDS);
        }
    }

    private static JSONObject R$$r_(Throwable throwable, String string2) throws JSONException {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object;
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            object = stackTraceElementArray[i];
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("class_name", (Object)((StackTraceElement)object).getClassName());
            jSONObject2.put("filename", (Object)((StackTraceElement)object).getFileName());
            jSONObject2.put("method", (Object)((StackTraceElement)object).getMethodName());
            if (((StackTraceElement)object).getLineNumber() > 0) {
                jSONObject2.put("lineno", ((StackTraceElement)object).getLineNumber());
            }
            jSONArray.put((Object)jSONObject2);
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace((PrintStream)object);
            ((PrintStream)object).close();
            byteArrayOutputStream.close();
            jSONObject.put("raw", (Object)byteArrayOutputStream.toString("UTF-8"));
        }
        catch (Exception exception) {
            Log.e((String)"Rollbar", (String)"Exception printing stack trace.", (Throwable)exception);
        }
        byteArrayOutputStream = new JSONObject();
        byteArrayOutputStream.put("class", throwable.getClass().getName());
        byteArrayOutputStream.put("message", throwable.getMessage());
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            byteArrayOutputStream.put("description", string2);
        }
        jSONObject.put("frames", (Object)jSONArray);
        jSONObject.put("exception", (Object)byteArrayOutputStream);
        return jSONObject;
    }

    public void uncaughtException(Throwable throwable) {
        if (this.r$_Y_) {
            Log.d((String)"Rollbar", (String)"Handling uncaught exception...");
            this.L__R$.interrupt();
            throwable = this.a_$P$(throwable, this.Y$_o$, null, new HashMap<String, String>());
            if (throwable != null) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)throwable);
                if (this.O_$B_) {
                    this.postItems(jSONArray, null);
                } else {
                    this.writeItems(jSONArray);
                }
            }
            try {
                this.L__R$.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                Log.d((String)"Rollbar", (String)"Couldn't join rollbar thread", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject a_$P$(Throwable object, String string2, String object22, Map<String, String> map) {
        try {
            void var4_6;
            JSONObject jSONObject = new JSONObject();
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            do {
                arrayList.add(0, Notifier.R$$r_((Throwable)((Object)object), (String)object22));
            } while ((object = ((Throwable)((Object)object)).getCause()) != null);
            object = new JSONArray(arrayList);
            jSONObject.put("trace_chain", (Object)object);
            if (string2 == null) {
                string2 = this.E$_j$;
            }
            for (Map.Entry entry : var4_6.entrySet()) {
                jSONObject.put((String)entry.getKey(), entry.getValue());
            }
            return this.d__1_(string2, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return null;
        }
    }

    private JSONObject d__1_(String object, String string2, Map<String, String> object22) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("body", (Object)object);
            jSONObject.put("message", (Object)jSONObject2);
            for (Map.Entry entry : object22.entrySet()) {
                jSONObject2.put((String)entry.getKey(), entry.getValue());
            }
            return this.d__1_(string2, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return null;
        }
    }

    public void reportException(Throwable throwable, String string2, String string3) {
        if ((throwable = this.a_$P$(throwable, string2, string3, new HashMap<String, String>())) != null) {
            this.L__R$.queueItem((JSONObject)throwable);
        }
    }

    public void reportException(Throwable throwable, String string2, String string3, Map<String, String> map) {
        if ((throwable = this.a_$P$(throwable, string2, string3, map)) != null) {
            this.L__R$.queueItem((JSONObject)throwable);
        }
    }

    public void reportMessage(String string2, String string3) {
        if ((string2 = this.d__1_(string2, string3, new HashMap<String, String>())) != null) {
            this.L__R$.queueItem((JSONObject)string2);
        }
    }

    public void reportMessage(String string2, String string3, Map<String, String> map) {
        if ((string2 = this.d__1_(string2, string3, map)) != null) {
            this.L__R$.queueItem((JSONObject)string2);
        }
    }

    public void setPersonData(JSONObject jSONObject) {
        this.b__J_ = jSONObject;
    }

    public void setPersonData(String string2, String string3, String string4) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", (Object)string2);
            if (string3 != null) {
                jSONObject.put("username", (Object)string3);
            }
            if (string4 != null) {
                jSONObject.put("email", (Object)string4);
            }
            this.b__J_ = jSONObject;
            return;
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"JSON error creating person data.", (Throwable)jSONException);
            return;
        }
    }

    public void setEndpoint(String string2) {
        this.B$$W$ = string2;
    }

    public void setReportUncaughtExceptions(boolean bl) {
        this.r$_Y_ = bl;
    }

    public void setIncludeLogcat(boolean bl) {
        this.D$_X_ = bl;
    }

    public void setDefaultCaughtExceptionLevel(String string2) {
        this.E$_j$ = string2;
    }

    public void setUncaughtExceptionLevel(String string2) {
        this.Y$_o$ = string2;
    }

    public void setSendOnUncaughtException(boolean bl) {
        this.O_$B_ = bl;
    }

    public void setItemScheduleDelay(int n) {
        this.E$_6$ = n;
    }

    static /* synthetic */ boolean Q_$2$(Notifier notifier) {
        notifier.Q_$2$ = false;
        return false;
    }
}

