/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.transport;

import com.hierynomus.protocol.transport.TransportException;
import com.hierynomus.smbj.common.SMBException;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.PipeShare;
import com.hierynomus.smbj.share.Share;
import com.rapid7.client.dcerpc.Interface;
import com.rapid7.client.dcerpc.transport.RPCTransport;
import com.rapid7.client.dcerpc.transport.SMBTransport;
import com.rapid7.helper.smbj.io.SMB2Exception;
import com.rapid7.helper.smbj.share.NamedPipe;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.LinkedList;

public enum SMBTransportFactories {
    WINREG("winreg", Interface.WINREG_V1_0, Interface.NDR_32BIT_V2),
    SRVSVC("srvsvc", Interface.SRVSVC_V3_0, Interface.NDR_32BIT_V2),
    LSASVC("lsarpc", Interface.LSASVC_V0_0, Interface.NDR_32BIT_V2),
    SAMSVC("samr", Interface.SAMSVC_V1_0, Interface.NDR_32BIT_V2),
    BROWSER_SRVSVC("browser", Interface.SRVSVC_V3_0, Interface.NDR_32BIT_V2),
    SVCCTL("svcctl", Interface.SVCCTL_V2_0, Interface.NDR_32BIT_V2);

    private static final int STATUS_PIPE_NOT_AVAILABLE_BACKOFF_TIME_MS = 3000;
    private static final int STATUS_PIPE_NOT_AVAILABLE_RETRIES = 1;
    private final String name;
    private final Interface abstractSyntax;
    private final Interface transferSyntax;

    private SMBTransportFactories(String path, Interface abstractSyntax, Interface transferSyntax) {
        this.name = path;
        this.abstractSyntax = abstractSyntax;
        this.transferSyntax = transferSyntax;
    }

    public RPCTransport getTransport(Session session) throws IOException {
        Share share = session.connectShare("IPC$");
        if (share instanceof PipeShare) {
            PipeShare pipeShare = (PipeShare)share;
            NamedPipe namedPipe = this.openAndHandleStatusPipeNotAvailable(session, pipeShare);
            SMBTransport transport = new SMBTransport(namedPipe);
            transport.bind(this.abstractSyntax, this.transferSyntax);
            return transport;
        }
        throw new TransportException(String.format("%s not a named pipe.", this.name));
    }

    private NamedPipe openAndHandleStatusPipeNotAvailable(Session session, PipeShare pipeShare) throws IOException {
        LinkedList<SMB2Exception> exceptions = new LinkedList<SMB2Exception>();
        block7: for (int retry = -1; retry < 1; ++retry) {
            try {
                return this.openPipe(session, pipeShare);
            }
            catch (SMB2Exception exception) {
                exceptions.offer(exception);
                switch (exception.getStatus()) {
                    case STATUS_PIPE_NOT_AVAILABLE: {
                        try {
                            Thread.sleep(3000L);
                            continue block7;
                        }
                        catch (InterruptedException iException) {
                            InterruptedIOException iioException = new InterruptedIOException();
                            iioException.addSuppressed(iException);
                            throw iioException;
                        }
                    }
                    default: {
                        throw (SMB2Exception)exceptions.poll();
                    }
                }
            }
        }
        if (!exceptions.isEmpty()) {
            throw (SMB2Exception)exceptions.poll();
        }
        throw new SMBException("Unknown error when opening pipe: " + pipeShare.getSmbPath().toString());
    }

    private NamedPipe openPipe(Session session, PipeShare pipeShare) throws IOException {
        return new NamedPipe(session, pipeShare, this.name);
    }
}

