/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msvcctl.dto.enums;

import java.util.HashMap;
import java.util.Map;

public enum ServiceType {
    KERNEL_DRIVER(1),
    FILE_SYSTEM_DRIVER(2),
    ADAPTER(4),
    RECOGNIZER_DRIVER(8),
    WIN32_OWN_PROCESS(16),
    WIN32_SHARE_PROCESS(32),
    INTERACTIVE_PROCESS(256),
    NO_CHANGE(-1),
    UNKNOWN(-1);

    private final int m_value;
    private static final Map<Integer, ServiceType> MS_TYPEDMAP;

    private ServiceType(int value) {
        this.m_value = value;
    }

    public int getValue() {
        return this.m_value;
    }

    public static ServiceType fromInt(int value) {
        ServiceType type = MS_TYPEDMAP.get(value);
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    static {
        MS_TYPEDMAP = new HashMap<Integer, ServiceType>();
        for (ServiceType type : ServiceType.values()) {
            MS_TYPEDMAP.put(type.getValue(), type);
        }
    }
}

