/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssrvs.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareEnumLevel;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfoContainer;
import java.io.IOException;
import java.rmi.UnmarshalException;

public abstract class ShareEnumStruct<T extends ShareInfoContainer>
implements Unmarshallable {
    private T shareInfoContainer;

    public abstract ShareEnumLevel getLevel();

    public T getShareInfoContainer() {
        return this.shareInfoContainer;
    }

    abstract T createShareInfoContainer();

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        int level = in.readInt();
        if (level != this.getLevel().getInfoLevel()) {
            throw new UnmarshalException(String.format("Expected info level %d, got: %d", this.getLevel().getInfoLevel(), level));
        }
        int enumLevel = in.readInt();
        if (enumLevel != level) {
            throw new UnmarshalException(String.format("Expected info level %d to match enum level, got: %d", level, enumLevel));
        }
        this.shareInfoContainer = in.readReferentID() != 0 ? this.createShareInfoContainer() : null;
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.getShareInfoContainer() != null) {
            in.readUnmarshallable(this.getShareInfoContainer());
        }
    }

    public static class ShareEnumStruct503
    extends ShareEnumStruct<ShareInfoContainer.ShareInfo503Container> {
        @Override
        public ShareEnumLevel getLevel() {
            return ShareEnumLevel.SHARE_INFO_503_CONTAINER;
        }

        @Override
        ShareInfoContainer.ShareInfo503Container createShareInfoContainer() {
            return new ShareInfoContainer.ShareInfo503Container();
        }
    }

    public static class ShareEnumStruct502
    extends ShareEnumStruct<ShareInfoContainer.ShareInfo502Container> {
        @Override
        public ShareEnumLevel getLevel() {
            return ShareEnumLevel.SHARE_INFO_502_CONTAINER;
        }

        @Override
        ShareInfoContainer.ShareInfo502Container createShareInfoContainer() {
            return new ShareInfoContainer.ShareInfo502Container();
        }
    }

    public static class ShareEnumStruct501
    extends ShareEnumStruct<ShareInfoContainer.ShareInfo501Container> {
        @Override
        public ShareEnumLevel getLevel() {
            return ShareEnumLevel.SHARE_INFO_501_CONTAINER;
        }

        @Override
        ShareInfoContainer.ShareInfo501Container createShareInfoContainer() {
            return new ShareInfoContainer.ShareInfo501Container();
        }
    }

    public static class ShareEnumStruct2
    extends ShareEnumStruct<ShareInfoContainer.ShareInfo2Container> {
        @Override
        public ShareEnumLevel getLevel() {
            return ShareEnumLevel.SHARE_INFO_2_CONTAINER;
        }

        @Override
        ShareInfoContainer.ShareInfo2Container createShareInfoContainer() {
            return new ShareInfoContainer.ShareInfo2Container();
        }
    }

    public static class ShareEnumStruct1
    extends ShareEnumStruct<ShareInfoContainer.ShareInfo1Container> {
        @Override
        public ShareEnumLevel getLevel() {
            return ShareEnumLevel.SHARE_INFO_1_CONTAINER;
        }

        @Override
        ShareInfoContainer.ShareInfo1Container createShareInfoContainer() {
            return new ShareInfoContainer.ShareInfo1Container();
        }
    }

    public static class ShareEnumStruct0
    extends ShareEnumStruct<ShareInfoContainer.ShareInfo0Container> {
        @Override
        public ShareEnumLevel getLevel() {
            return ShareEnumLevel.SHARE_INFO_0_CONTAINER;
        }

        @Override
        ShareInfoContainer.ShareInfo0Container createShareInfoContainer() {
            return new ShareInfoContainer.ShareInfo0Container();
        }
    }
}

