/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.Arrays;

public class SAMPRSRSecurityDescriptor
implements Unmarshallable {
    private byte[] securityDescriptor;

    public byte[] getSecurityDescriptor() {
        return this.securityDescriptor;
    }

    public void setSecurityDescriptor(byte[] securityDescriptor) {
        this.securityDescriptor = securityDescriptor;
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        int length = this.readLength(in);
        if (in.readReferentID() != 0) {
            if (length > 0) {
                this.securityDescriptor = new byte[length];
            }
        } else {
            this.securityDescriptor = null;
        }
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.securityDescriptor != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            for (int i = 0; i < this.securityDescriptor.length; ++i) {
                this.securityDescriptor[i] = in.readByte();
            }
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.securityDescriptor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SAMPRSRSecurityDescriptor)) {
            return false;
        }
        return Arrays.equals(this.getSecurityDescriptor(), ((SAMPRSRSecurityDescriptor)obj).getSecurityDescriptor());
    }

    public String toString() {
        return String.format("SAMPR_SR_SECURITY_DESCRIPTOR{size_of(SecurityDescriptor):%s}", this.securityDescriptor == null ? "null" : Integer.valueOf(this.securityDescriptor.length));
    }

    private int readLength(PacketInput in) throws IOException {
        long ret = in.readUnsignedInt();
        if (ret > Integer.MAX_VALUE) {
            throw new UnmarshalException(String.format("Length %d > %d", ret, Integer.MAX_VALUE));
        }
        return (int)ret;
    }
}

