/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.mssamr.objects.GroupInformationClass;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRGroupGeneralInformation;
import java.io.IOException;
import java.rmi.UnmarshalException;

public abstract class SamrQueryInformationGroupResponse<T extends Unmarshallable>
extends RequestResponse {
    private T groupInformation;

    public T getGroupInformation() {
        return this.groupInformation;
    }

    public abstract GroupInformationClass getGroupInformationClass();

    abstract T createGroupInformation();

    @Override
    public void unmarshalResponse(PacketInput packetIn) throws IOException {
        if (packetIn.readReferentID() != 0) {
            int infoLevel = packetIn.readUnsignedShort();
            if (infoLevel != this.getGroupInformationClass().getInfoLevel()) {
                throw new UnmarshalException(String.format("Incoming GROUP_INFORMATION_CLASS %d does not match expected: %d", infoLevel, this.getGroupInformationClass().getInfoLevel()));
            }
            this.groupInformation = this.createGroupInformation();
            packetIn.readUnmarshallable(this.groupInformation);
        } else {
            this.groupInformation = null;
        }
    }

    public static class GroupGeneralInformation
    extends SamrQueryInformationGroupResponse<SAMPRGroupGeneralInformation> {
        @Override
        public GroupInformationClass getGroupInformationClass() {
            return GroupInformationClass.GROUP_GENERAL_INFORMATION;
        }

        @Override
        SAMPRGroupGeneralInformation createGroupInformation() {
            return new SAMPRGroupGeneralInformation();
        }
    }
}

