/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.mssamr.objects.AliasInformationClass;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRAliasGeneralInformation;
import java.io.IOException;
import java.rmi.UnmarshalException;

public abstract class SamrQueryInformationAliasResponse<T extends Unmarshallable>
extends RequestResponse {
    private T aliasInformation;

    public T getAliasInformation() {
        return this.aliasInformation;
    }

    public abstract AliasInformationClass getAliasInformationClass();

    abstract T createAliasInformation();

    @Override
    public void unmarshalResponse(PacketInput packetIn) throws IOException {
        if (packetIn.readReferentID() != 0) {
            int infoLevel = packetIn.readUnsignedShort();
            if (infoLevel != this.getAliasInformationClass().getInfoLevel()) {
                throw new UnmarshalException(String.format("Incoming ALIAS_INFORMATION_CLASS %d does not match expected: %d", infoLevel, this.getAliasInformationClass().getInfoLevel()));
            }
            this.aliasInformation = this.createAliasInformation();
            packetIn.readUnmarshallable(this.aliasInformation);
        } else {
            this.aliasInformation = null;
        }
    }

    public static class AliasGeneralInformation
    extends SamrQueryInformationAliasResponse<SAMPRAliasGeneralInformation> {
        @Override
        public AliasInformationClass getAliasInformationClass() {
            return AliasInformationClass.ALIAS_GENERALINFORMATION;
        }

        @Override
        SAMPRAliasGeneralInformation createAliasInformation() {
            return new SAMPRAliasGeneralInformation();
        }
    }
}

