/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.objects.RPCSID;
import com.rapid7.client.dcerpc.objects.RPCUnicodeString;
import java.io.IOException;
import java.util.Objects;

public class LSAPRTrustInformation
implements Unmarshallable {
    private RPCUnicodeString.NonNullTerminated name;
    private RPCSID sid;

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
        this.name = new RPCUnicodeString.NonNullTerminated();
        this.name.unmarshalPreamble(in);
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        this.name.unmarshalEntity(in);
        in.align(Alignment.FOUR);
        this.sid = in.readReferentID() != 0 ? new RPCSID() : null;
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        this.name.unmarshalDeferrals(in);
        if (this.sid != null) {
            in.readUnmarshallable(this.sid);
        }
    }

    public RPCUnicodeString.NonNullTerminated getName() {
        return this.name;
    }

    public RPCSID getSid() {
        return this.sid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LSAPRTrustInformation)) {
            return false;
        }
        LSAPRTrustInformation other = (LSAPRTrustInformation)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.sid, other.sid);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.sid);
    }

    public String toString() {
        return String.format("LSAPR_TRUST_INFORMATION{Name:%s,Sid:%s}", this.name, this.sid);
    }
}

