/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.messages;

import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.mslsad.messages.LsarQueryInformationPolicyResponse;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyAccountDomInfo;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyAuditEventsInfo;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyPrimaryDomInfo;
import com.rapid7.client.dcerpc.mslsad.objects.PolicyInformationClass;
import java.io.IOException;

public abstract class LsarQueryInformationPolicyRequest<T extends Unmarshallable>
extends RequestCall<LsarQueryInformationPolicyResponse<T>> {
    public static final short OP_NUM = 7;
    private final byte[] policyHandle;

    public LsarQueryInformationPolicyRequest(byte[] policyHandle) {
        super((short)7);
        this.policyHandle = policyHandle;
    }

    public byte[] getPolicyHandle() {
        return this.policyHandle;
    }

    public abstract PolicyInformationClass getPolicyInformationClass();

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        packetOut.write(this.policyHandle);
        packetOut.writeShort(this.getPolicyInformationClass().getInfoLevel());
    }

    public static class PolicyAccountDomainInformation
    extends LsarQueryInformationPolicyRequest<LSAPRPolicyAccountDomInfo> {
        public PolicyAccountDomainInformation(byte[] policyHandle) {
            super(policyHandle);
        }

        @Override
        public PolicyInformationClass getPolicyInformationClass() {
            return PolicyInformationClass.POLICY_ACCOUNT_DOMAIN_INFORMATION;
        }

        @Override
        public LsarQueryInformationPolicyResponse.PolicyAccountDomainInformation getResponseObject() {
            return new LsarQueryInformationPolicyResponse.PolicyAccountDomainInformation();
        }
    }

    public static class PolicyPrimaryDomainInformation
    extends LsarQueryInformationPolicyRequest<LSAPRPolicyPrimaryDomInfo> {
        public PolicyPrimaryDomainInformation(byte[] policyHandle) {
            super(policyHandle);
        }

        @Override
        public PolicyInformationClass getPolicyInformationClass() {
            return PolicyInformationClass.POLICY_PRIMARY_DOMAIN_INFORMATION;
        }

        @Override
        public LsarQueryInformationPolicyResponse.PolicyPrimaryDomainInformation getResponseObject() {
            return new LsarQueryInformationPolicyResponse.PolicyPrimaryDomainInformation();
        }
    }

    public static class PolicyAuditEventsInformation
    extends LsarQueryInformationPolicyRequest<LSAPRPolicyAuditEventsInfo> {
        public PolicyAuditEventsInformation(byte[] policyHandle) {
            super(policyHandle);
        }

        @Override
        public PolicyInformationClass getPolicyInformationClass() {
            return PolicyInformationClass.POLICY_AUDIT_EVENTS_INFORMATION;
        }

        @Override
        public LsarQueryInformationPolicyResponse.PolicyAuditEventsInformation getResponseObject() {
            return new LsarQueryInformationPolicyResponse.PolicyAuditEventsInformation();
        }
    }
}

