/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.messages;

import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.mslsad.messages.LsarLookupNamesResponse;
import com.rapid7.client.dcerpc.objects.RPCUnicodeString;
import java.io.IOException;

public class LsarLookupNamesRequest
extends RequestCall<LsarLookupNamesResponse> {
    private static final short OP_NUM = 14;
    private final byte[] policyHandle;
    private final RPCUnicodeString.NonNullTerminated[] names;
    private final short lookupLevel;

    public LsarLookupNamesRequest(byte[] policyHandle, RPCUnicodeString.NonNullTerminated[] names, short lookupLevel) {
        super((short)14);
        this.policyHandle = policyHandle;
        this.names = names;
        this.lookupLevel = lookupLevel;
    }

    @Override
    public LsarLookupNamesResponse getResponseObject() {
        return new LsarLookupNamesResponse();
    }

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        packetOut.write(this.policyHandle);
        packetOut.writeInt(this.names.length);
        this.writeNames(packetOut);
        packetOut.align(Alignment.FOUR);
        packetOut.writeInt(0);
        packetOut.writeNull();
        packetOut.writeShort(this.lookupLevel);
        packetOut.pad(2L);
        packetOut.writeNull();
    }

    private void writeNames(PacketOutput packetOut) throws IOException {
        packetOut.writeInt(this.names.length);
        for (RPCUnicodeString.NonNullTerminated name : this.names) {
            name.marshalPreamble(packetOut);
        }
        for (RPCUnicodeString.NonNullTerminated name : this.names) {
            name.marshalEntity(packetOut);
        }
        for (RPCUnicodeString.NonNullTerminated name : this.names) {
            name.marshalDeferrals(packetOut);
        }
    }
}

