/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.dto;

import com.rapid7.client.dcerpc.mslsad.dto.PolicyAuditEventType;
import java.util.Arrays;
import java.util.Objects;

public class PolicyAuditEventsInfo {
    private final boolean auditEnabled;
    private final int[] eventAuditingOptions;

    public PolicyAuditEventsInfo(boolean auditEnabled, int[] eventAuditingOptions) {
        if (eventAuditingOptions == null) {
            throw new IllegalArgumentException("Expecting non-null eventAuditingOptions");
        }
        if (eventAuditingOptions.length != 9) {
            throw new IllegalArgumentException(String.format("Expecting 9 elements in eventAuditingOptions, got: %d", eventAuditingOptions.length));
        }
        this.auditEnabled = auditEnabled;
        this.eventAuditingOptions = eventAuditingOptions;
    }

    public boolean isAuditEnabled() {
        return this.auditEnabled;
    }

    public int getEventAuditingOptionForType(PolicyAuditEventType eventType) {
        return this.eventAuditingOptions[eventType.getValue() - 1];
    }

    public int[] getEventAuditingOptions() {
        return this.eventAuditingOptions;
    }

    public int hashCode() {
        int ret = this.auditEnabled ? 1 : 0;
        ret = 31 * ret + Arrays.hashCode(this.eventAuditingOptions);
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolicyAuditEventsInfo)) {
            return false;
        }
        PolicyAuditEventsInfo other = (PolicyAuditEventsInfo)obj;
        return Objects.equals(this.auditEnabled, other.auditEnabled) && Arrays.equals(this.eventAuditingOptions, other.eventAuditingOptions);
    }

    public String toString() {
        return String.format("PolicyAuditEventsInfo{auditMode:%b, eventAuditingOptions:%s}", this.auditEnabled, Arrays.toString(this.eventAuditingOptions));
    }
}

