/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad;

import com.rapid7.client.dcerpc.RPCException;
import com.rapid7.client.dcerpc.dto.SID;
import com.rapid7.client.dcerpc.messages.HandleResponse;
import com.rapid7.client.dcerpc.mserref.SystemErrorCode;
import com.rapid7.client.dcerpc.mslsad.dto.LSAPLookupLevel;
import com.rapid7.client.dcerpc.mslsad.dto.PolicyAuditEventsInfo;
import com.rapid7.client.dcerpc.mslsad.dto.PolicyDomainInfo;
import com.rapid7.client.dcerpc.mslsad.dto.PolicyHandle;
import com.rapid7.client.dcerpc.mslsad.messages.LsarCloseRequest;
import com.rapid7.client.dcerpc.mslsad.messages.LsarEnumerateAccountRightsRequest;
import com.rapid7.client.dcerpc.mslsad.messages.LsarEnumerateAccountsWithUserRightRequest;
import com.rapid7.client.dcerpc.mslsad.messages.LsarLookupNamesRequest;
import com.rapid7.client.dcerpc.mslsad.messages.LsarLookupNamesResponse;
import com.rapid7.client.dcerpc.mslsad.messages.LsarLookupSIDsRequest;
import com.rapid7.client.dcerpc.mslsad.messages.LsarLookupSIDsResponse;
import com.rapid7.client.dcerpc.mslsad.messages.LsarOpenPolicy2Request;
import com.rapid7.client.dcerpc.mslsad.messages.LsarQueryInformationPolicyRequest;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyAccountDomInfo;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyAuditEventsInfo;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyPrimaryDomInfo;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRTranslatedName;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRTranslatedSID;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRTrustInformation;
import com.rapid7.client.dcerpc.objects.RPCSID;
import com.rapid7.client.dcerpc.objects.RPCUnicodeString;
import com.rapid7.client.dcerpc.objects.WChar;
import com.rapid7.client.dcerpc.service.Service;
import com.rapid7.client.dcerpc.transport.RPCTransport;
import java.io.IOException;

public class LocalSecurityAuthorityService
extends Service {
    public static final int MAXIMUM_ALLOWED = 0x2000000;

    public LocalSecurityAuthorityService(RPCTransport transport) {
        super(transport);
    }

    public PolicyHandle openPolicyHandle() throws IOException {
        return this.openPolicyHandle(0x2000000);
    }

    public PolicyHandle openPolicyHandle(int desiredAccess) throws IOException {
        return this.openPolicyHandle("", desiredAccess);
    }

    public PolicyHandle openPolicyHandle(String serverName, int desiredAccess) throws IOException {
        if (serverName == null) {
            serverName = "";
        }
        LsarOpenPolicy2Request request = new LsarOpenPolicy2Request(WChar.NullTerminated.of(serverName), desiredAccess);
        return this.parsePolicyHandle(this.callExpectSuccess(request, "LsarOpenPolicy2").getHandle());
    }

    public boolean closePolicyHandle(PolicyHandle handle) throws IOException {
        LsarCloseRequest request = new LsarCloseRequest(this.parseHandle(handle));
        HandleResponse response = this.call(request);
        if (SystemErrorCode.ERROR_SUCCESS.is(response.getReturnValue())) {
            return true;
        }
        if (SystemErrorCode.STATUS_INVALID_HANDLE.is(response.getReturnValue())) {
            return false;
        }
        throw new RPCException("LsarClose", response.getReturnValue());
    }

    public PolicyAuditEventsInfo getPolicyAuditEventsInfo(PolicyHandle policyHandle) throws IOException {
        LsarQueryInformationPolicyRequest.PolicyAuditEventsInformation request = new LsarQueryInformationPolicyRequest.PolicyAuditEventsInformation(this.parseHandle(policyHandle));
        LSAPRPolicyAuditEventsInfo policyInformation = this.callExpectSuccess(request, "LsarQueryInformationPolicy[2]").getPolicyInformation();
        if (policyInformation == null) {
            return null;
        }
        return new PolicyAuditEventsInfo(policyInformation.getAuditingMode() != '\u0000', policyInformation.getEventAuditingOptions());
    }

    public PolicyDomainInfo getPolicyPrimaryDomainInformation(PolicyHandle policyHandle) throws IOException {
        LsarQueryInformationPolicyRequest.PolicyPrimaryDomainInformation request = new LsarQueryInformationPolicyRequest.PolicyPrimaryDomainInformation(this.parseHandle(policyHandle));
        LSAPRPolicyPrimaryDomInfo policyInformation = this.callExpectSuccess(request, "LsarQueryInformationPolicy[3]").getPolicyInformation();
        if (policyInformation == null) {
            return null;
        }
        return new PolicyDomainInfo(this.parseRPCUnicodeString(policyInformation.getName()), this.parseRPCSID(policyInformation.getSid()));
    }

    public PolicyDomainInfo getPolicyAccountDomainInformation(PolicyHandle policyHandle) throws IOException {
        LsarQueryInformationPolicyRequest.PolicyAccountDomainInformation request = new LsarQueryInformationPolicyRequest.PolicyAccountDomainInformation(this.parseHandle(policyHandle));
        LSAPRPolicyAccountDomInfo policyInformation = this.callExpectSuccess(request, "LsarQueryInformationPolicy[5]").getPolicyInformation();
        if (policyInformation == null) {
            return null;
        }
        return new PolicyDomainInfo(this.parseRPCUnicodeString(policyInformation.getDomainName()), this.parseRPCSID(policyInformation.getDomainSid()));
    }

    public String[] getAccountRights(PolicyHandle policyHandle, SID sid) throws IOException {
        LsarEnumerateAccountRightsRequest request = new LsarEnumerateAccountRightsRequest(this.parseHandle(policyHandle), this.parseSID(sid));
        RPCUnicodeString[] privNames = this.callExpectSuccess(request, "LsarEnumerateAccountRights").getPrivNames();
        return this.parseRPCUnicodeStrings(privNames);
    }

    public SID[] getAccountsWithUserRight(PolicyHandle policyHandle, String userRight) throws IOException {
        LsarEnumerateAccountsWithUserRightRequest request = new LsarEnumerateAccountsWithUserRightRequest(this.parseHandle(policyHandle), RPCUnicodeString.NonNullTerminated.of(userRight));
        RPCSID[] rpcsids = this.callExpect(request, "LsarEnumerateAccountsWithUserRight", SystemErrorCode.ERROR_SUCCESS, SystemErrorCode.STATUS_NO_MORE_ENTRIES).getSids();
        return this.parseRPCSIDs(rpcsids);
    }

    public SID[] lookupSIDsForNames(PolicyHandle policyHandle, String ... names) throws IOException {
        return this.lookupSIDsForNames(policyHandle, LSAPLookupLevel.LSAP_LOOKUP_WKSTA, names);
    }

    public SID[] lookupSIDsForNames(PolicyHandle policyHandle, LSAPLookupLevel lookupLevel, String ... names) throws IOException {
        LSAPRTrustInformation[] domainArray;
        LsarLookupNamesRequest request = new LsarLookupNamesRequest(this.parseHandle(policyHandle), this.parseNonNullTerminatedStrings(names), lookupLevel.getValue());
        LsarLookupNamesResponse response = this.callExpect(request, "LsarLookupNames", SystemErrorCode.ERROR_SUCCESS, SystemErrorCode.STATUS_SOME_NOT_MAPPED, SystemErrorCode.STATUS_NONE_MAPPED);
        LSAPRTranslatedSID[] translatedSIDs = response.getTranslatedSIDs().getSIDs();
        if (translatedSIDs == null) {
            translatedSIDs = new LSAPRTranslatedSID[]{};
        }
        if ((domainArray = response.getReferencedDomains().getDomains()) == null) {
            domainArray = new LSAPRTrustInformation[]{};
        }
        SID[] sids = new SID[translatedSIDs.length];
        for (int i = 0; i < translatedSIDs.length; ++i) {
            RPCSID sid;
            int domainIndex;
            LSAPRTranslatedSID translatedSID = translatedSIDs[i];
            if (translatedSID == null || (domainIndex = (int)translatedSID.getDomainIndex()) < 0 || (sid = domainArray[domainIndex].getSid()) == null) continue;
            SID dtoSID = this.parseRPCSID(sid, false);
            sids[i] = dtoSID.resolveRelativeID(translatedSID.getRelativeId());
        }
        return sids;
    }

    public String[] lookupNamesForSIDs(PolicyHandle policyHandle, SID ... sids) throws IOException {
        return this.lookupNamesForSIDs(policyHandle, LSAPLookupLevel.LSAP_LOOKUP_WKSTA, sids);
    }

    public String[] lookupNamesForSIDs(PolicyHandle policyHandle, LSAPLookupLevel lookupLevel, SID ... sids) throws IOException {
        LsarLookupSIDsRequest request = new LsarLookupSIDsRequest(this.parseHandle(policyHandle), this.parseSIDs(sids), lookupLevel.getValue());
        LsarLookupSIDsResponse lsarLookupSIDsResponse = this.callExpect(request, "LsarLookupSIDs", SystemErrorCode.ERROR_SUCCESS, SystemErrorCode.STATUS_SOME_NOT_MAPPED, SystemErrorCode.STATUS_NONE_MAPPED);
        LSAPRTranslatedName[] nameArray = lsarLookupSIDsResponse.getTranslatedNames().getNames();
        if (nameArray == null) {
            nameArray = new LSAPRTranslatedName[]{};
        }
        String[] mappedNames = new String[nameArray.length];
        for (int i = 0; i < nameArray.length; ++i) {
            mappedNames[i] = this.parseRPCUnicodeString(nameArray[i].getName());
        }
        return mappedNames;
    }

    private PolicyHandle parsePolicyHandle(byte[] handle) {
        return new PolicyHandle(handle);
    }
}

