/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.messages;

import com.rapid7.client.dcerpc.Header;
import com.rapid7.client.dcerpc.PDUType;
import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import java.io.IOException;

public final class Response
extends Header {
    private byte[] stub;

    public Response() {
        this.setPDUType(PDUType.RESPONSE);
    }

    public byte[] getStub() {
        return this.stub;
    }

    public void setStub(byte[] stub) {
        this.stub = stub;
    }

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        this.setFragLength((short)(24 + this.stub.length));
        super.marshal(packetOut);
        packetOut.writeInt(0);
        packetOut.writeShort(0);
        packetOut.writeByte(0);
        packetOut.align(Alignment.FOUR);
        packetOut.write(this.getStub());
        packetOut.write(new byte[this.getAuthLength()]);
    }

    @Override
    public void unmarshal(PacketInput packetIn) throws IOException {
        super.unmarshal(packetIn);
        this.setStub(new byte[this.getFragLength() - this.getAuthLength() - 24]);
        packetIn.fullySkipBytes(8);
        packetIn.readFully(this.getStub());
        packetIn.fullySkipBytes(this.getAuthLength());
    }
}

