/*
 * Decompiled with CFR 0.152.
 */
package com.ramotion.foldingcell.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.RelativeLayout;

public class FoldingCellView
extends RelativeLayout {
    private View mBackView;
    private View mFrontView;

    public FoldingCellView(Context context, AttributeSet attrs) {
        super(context, attrs);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setClipToPadding(false);
        this.setClipChildren(false);
    }

    public FoldingCellView(View frontView, View backView, Context context) {
        super(context);
        this.mFrontView = frontView;
        this.mBackView = backView;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        this.setClipToPadding(false);
        this.setClipChildren(false);
        if (this.mBackView != null) {
            this.addView(this.mBackView);
            RelativeLayout.LayoutParams mBackViewParams = (RelativeLayout.LayoutParams)this.mBackView.getLayoutParams();
            mBackViewParams.addRule(12);
            this.mBackView.setLayoutParams((ViewGroup.LayoutParams)mBackViewParams);
            layoutParams.height = mBackViewParams.height;
        }
        if (this.mFrontView != null) {
            this.addView(this.mFrontView);
            RelativeLayout.LayoutParams frontViewLayoutParams = (RelativeLayout.LayoutParams)this.mFrontView.getLayoutParams();
            frontViewLayoutParams.addRule(12);
            this.mFrontView.setLayoutParams((ViewGroup.LayoutParams)frontViewLayoutParams);
        }
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public FoldingCellView withFrontView(View frontView) {
        this.mFrontView = frontView;
        if (this.mFrontView != null) {
            this.addView(this.mFrontView);
            RelativeLayout.LayoutParams frontViewLayoutParams = (RelativeLayout.LayoutParams)this.mFrontView.getLayoutParams();
            frontViewLayoutParams.addRule(12);
            this.mFrontView.setLayoutParams((ViewGroup.LayoutParams)frontViewLayoutParams);
        }
        return this;
    }

    public FoldingCellView withBackView(View backView) {
        this.mBackView = backView;
        if (this.mBackView != null) {
            this.addView(this.mBackView);
            RelativeLayout.LayoutParams mBackViewParams = (RelativeLayout.LayoutParams)this.mBackView.getLayoutParams();
            mBackViewParams.addRule(12);
            this.mBackView.setLayoutParams((ViewGroup.LayoutParams)mBackViewParams);
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
            layoutParams.height = mBackViewParams.height;
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        return this;
    }

    public View getBackView() {
        return this.mBackView;
    }

    public View getFrontView() {
        return this.mFrontView;
    }

    public void animateFrontView(Animation animation) {
        if (this.mFrontView != null) {
            this.mFrontView.startAnimation(animation);
        }
    }
}

