/*
 * Decompiled with CFR 0.152.
 */
package com.ramotion.foldingcell.animations;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;

public class HeightAnimation
extends Animation {
    private final View mView;
    private final int mHeightFrom;
    private final int mHeightTo;

    public HeightAnimation(View mView, int heightFrom, int heightTo, int duration) {
        this.mView = mView;
        this.mHeightFrom = heightFrom;
        this.mHeightTo = heightTo;
        this.setDuration(duration);
    }

    public HeightAnimation withInterpolator(Interpolator interpolator) {
        if (interpolator != null) {
            this.setInterpolator(interpolator);
        }
        return this;
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float newHeight = (float)this.mHeightFrom + (float)(this.mHeightTo - this.mHeightFrom) * interpolatedTime;
        this.mView.getLayoutParams().height = interpolatedTime == 1.0f ? this.mHeightTo : (int)newHeight;
        this.mView.requestLayout();
    }

    public boolean willChangeBounds() {
        return true;
    }

    public boolean isFillEnabled() {
        return false;
    }

    public String toString() {
        return "HeightAnimation{mHeightFrom=" + this.mHeightFrom + ", mHeightTo=" + this.mHeightTo + ", offset =" + this.getStartOffset() + ", duration =" + this.getDuration() + '}';
    }
}

