/*
 * Decompiled with CFR 0.152.
 */
package com.ramotion.foldingcell;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.ramotion.foldingcell.R;
import com.ramotion.foldingcell.animations.AnimationEndListener;
import com.ramotion.foldingcell.animations.FoldAnimation;
import com.ramotion.foldingcell.animations.HeightAnimation;
import com.ramotion.foldingcell.views.FoldingCellView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FoldingCell
extends RelativeLayout {
    private final String TAG = "folding-cell";
    private boolean mUnfolded;
    private boolean mAnimationInProgress;
    private final int DEF_ANIMATION_DURATION = 1000;
    private final int DEF_BACK_SIDE_COLOR = -7829368;
    private final int DEF_ADDITIONAL_FLIPS = 0;
    private final int DEF_CAMERA_HEIGHT = 30;
    private int mAnimationDuration = 1000;
    private int mBackSideColor = -7829368;
    private int mAdditionalFlipsCount = 0;
    private int mCameraHeight = 30;

    public FoldingCell(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeFromAttributes(context, attrs);
        this.setClipChildren(false);
        this.setClipToPadding(false);
    }

    public FoldingCell(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeFromAttributes(context, attrs);
        this.setClipChildren(false);
        this.setClipToPadding(false);
    }

    public FoldingCell(Context context) {
        super(context);
        this.setClipChildren(false);
        this.setClipToPadding(false);
    }

    public void initialize(int animationDuration, int backSideColor, int additionalFlipsCount) {
        this.mAnimationDuration = animationDuration;
        this.mBackSideColor = backSideColor;
        this.mAdditionalFlipsCount = additionalFlipsCount;
    }

    public void initialize(int cameraHeight, int animationDuration, int backSideColor, int additionalFlipsCount) {
        this.mAnimationDuration = animationDuration;
        this.mBackSideColor = backSideColor;
        this.mAdditionalFlipsCount = additionalFlipsCount;
        this.mCameraHeight = cameraHeight;
    }

    public boolean isUnfolded() {
        return this.mUnfolded;
    }

    public void unfold(boolean skipAnimation) {
        if (this.mUnfolded || this.mAnimationInProgress) {
            return;
        }
        final View contentView = this.getChildAt(0);
        if (contentView == null) {
            return;
        }
        View titleView = this.getChildAt(1);
        if (titleView == null) {
            return;
        }
        titleView.setVisibility(8);
        contentView.setVisibility(8);
        Bitmap bitmapFromTitleView = this.measureViewAndGetBitmap(titleView, this.getMeasuredWidth());
        Bitmap bitmapFromContentView = this.measureViewAndGetBitmap(contentView, this.getMeasuredWidth());
        if (skipAnimation) {
            contentView.setVisibility(0);
            this.mUnfolded = true;
            this.mAnimationInProgress = false;
            this.getLayoutParams().height = contentView.getHeight();
        } else {
            final LinearLayout foldingLayout = this.createAndPrepareFoldingContainer();
            this.addView((View)foldingLayout);
            ArrayList<Integer> heights = this.calculateHeightsForAnimationParts(titleView.getHeight(), contentView.getHeight(), this.mAdditionalFlipsCount);
            ArrayList<FoldingCellView> foldingCellElements = this.prepareViewsForAnimation(heights, bitmapFromTitleView, bitmapFromContentView);
            int childCount = foldingCellElements.size();
            int part90degreeAnimationDuration = this.mAnimationDuration / (childCount * 2);
            this.startUnfoldAnimation(foldingCellElements, (ViewGroup)foldingLayout, part90degreeAnimationDuration, new AnimationEndListener(){

                public void onAnimationEnd(Animation animation) {
                    contentView.setVisibility(0);
                    foldingLayout.setVisibility(8);
                    FoldingCell.this.removeView((View)foldingLayout);
                    FoldingCell.this.mUnfolded = true;
                    FoldingCell.this.mAnimationInProgress = false;
                }
            });
            this.startExpandHeightAnimation(heights, part90degreeAnimationDuration * 2);
            this.mAnimationInProgress = true;
        }
    }

    public void fold(boolean skipAnimation) {
        if (!this.mUnfolded || this.mAnimationInProgress) {
            return;
        }
        final View contentView = this.getChildAt(0);
        if (contentView == null) {
            return;
        }
        final View titleView = this.getChildAt(1);
        if (titleView == null) {
            return;
        }
        titleView.setVisibility(8);
        contentView.setVisibility(8);
        Bitmap bitmapFromTitleView = this.measureViewAndGetBitmap(titleView, this.getMeasuredWidth());
        Bitmap bitmapFromContentView = this.measureViewAndGetBitmap(contentView, this.getMeasuredWidth());
        if (skipAnimation) {
            contentView.setVisibility(8);
            titleView.setVisibility(0);
            this.mAnimationInProgress = false;
            this.mUnfolded = false;
            this.getLayoutParams().height = titleView.getHeight();
        } else {
            final LinearLayout foldingLayout = this.createAndPrepareFoldingContainer();
            this.addView((View)foldingLayout);
            ArrayList<Integer> heights = this.calculateHeightsForAnimationParts(titleView.getHeight(), contentView.getHeight(), this.mAdditionalFlipsCount);
            ArrayList<FoldingCellView> foldingCellElements = this.prepareViewsForAnimation(heights, bitmapFromTitleView, bitmapFromContentView);
            int childCount = foldingCellElements.size();
            int part90degreeAnimationDuration = this.mAnimationDuration / (childCount * 2);
            this.startFoldAnimation(foldingCellElements, (ViewGroup)foldingLayout, part90degreeAnimationDuration, new AnimationEndListener(){

                public void onAnimationEnd(Animation animation) {
                    contentView.setVisibility(8);
                    titleView.setVisibility(0);
                    foldingLayout.setVisibility(8);
                    FoldingCell.this.removeView((View)foldingLayout);
                    FoldingCell.this.mAnimationInProgress = false;
                    FoldingCell.this.mUnfolded = false;
                }
            });
            this.startCollapseHeightAnimation(heights, part90degreeAnimationDuration * 2);
            this.mAnimationInProgress = true;
        }
    }

    public void toggle(boolean skipAnimation) {
        if (this.mUnfolded) {
            this.fold(skipAnimation);
        } else {
            this.unfold(skipAnimation);
            this.requestLayout();
        }
    }

    protected ArrayList<FoldingCellView> prepareViewsForAnimation(ArrayList<Integer> viewHeights, Bitmap titleViewBitmap, Bitmap contentViewBitmap) {
        if (viewHeights == null || viewHeights.isEmpty()) {
            throw new IllegalStateException("ViewHeights array must be not null and not empty");
        }
        ArrayList<FoldingCellView> partsList = new ArrayList<FoldingCellView>();
        int partWidth = titleViewBitmap.getWidth();
        int yOffset = 0;
        for (int i = 0; i < viewHeights.size(); ++i) {
            int partHeight = viewHeights.get(i);
            Bitmap partBitmap = Bitmap.createBitmap((int)partWidth, (int)partHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(partBitmap);
            Rect srcRect = new Rect(0, yOffset, partWidth, yOffset + partHeight);
            Rect destRect = new Rect(0, 0, partWidth, partHeight);
            canvas.drawBitmap(contentViewBitmap, srcRect, destRect, null);
            ImageView backView = this.createImageViewFromBitmap(partBitmap);
            ImageView frontView = null;
            if (i < viewHeights.size() - 1) {
                frontView = i == 0 ? this.createImageViewFromBitmap(titleViewBitmap) : this.createBackSideView(viewHeights.get(i + 1));
            }
            partsList.add(new FoldingCellView((View)frontView, (View)backView, this.getContext()));
            yOffset += partHeight;
        }
        return partsList;
    }

    protected ArrayList<Integer> calculateHeightsForAnimationParts(int titleViewHeight, int contentViewHeight, int additionalFlipsCount) {
        ArrayList<Integer> partHeights = new ArrayList<Integer>();
        int additionalPartsTotalHeight = contentViewHeight - titleViewHeight * 2;
        if (additionalPartsTotalHeight < 0) {
            throw new IllegalStateException("Content View height is too small");
        }
        partHeights.add(titleViewHeight);
        partHeights.add(titleViewHeight);
        if (additionalPartsTotalHeight == 0) {
            return partHeights;
        }
        if (additionalFlipsCount != 0) {
            int additionalPartHeight = additionalPartsTotalHeight / additionalFlipsCount;
            int remainingHeight = additionalPartsTotalHeight % additionalFlipsCount;
            if (additionalPartHeight + remainingHeight > titleViewHeight) {
                throw new IllegalStateException("Additional flips count is too small");
            }
            for (int i = 0; i < additionalFlipsCount; ++i) {
                partHeights.add(additionalPartHeight + (i == 0 ? remainingHeight : 0));
            }
        } else {
            int partsCount = additionalPartsTotalHeight / titleViewHeight;
            int restPartHeight = additionalPartsTotalHeight % titleViewHeight;
            for (int i = 0; i < partsCount; ++i) {
                partHeights.add(titleViewHeight);
            }
            if (restPartHeight > 0) {
                partHeights.add(restPartHeight);
            }
        }
        return partHeights;
    }

    protected ImageView createBackSideView(int height) {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setBackgroundColor(this.mBackSideColor);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
        return imageView;
    }

    protected ImageView createImageViewFromBitmap(Bitmap bitmap) {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setImageBitmap(bitmap);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(bitmap.getWidth(), bitmap.getHeight()));
        return imageView;
    }

    protected Bitmap measureViewAndGetBitmap(View view, int parentWidth) {
        int specW = View.MeasureSpec.makeMeasureSpec((int)parentWidth, (int)0x40000000);
        int specH = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(specW, specH);
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        Bitmap b = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(b);
        c.translate((float)(-view.getScrollX()), (float)(-view.getScrollY()));
        view.draw(c);
        return b;
    }

    protected LinearLayout createAndPrepareFoldingContainer() {
        LinearLayout foldingContainer = new LinearLayout(this.getContext());
        foldingContainer.setClipToPadding(false);
        foldingContainer.setClipChildren(false);
        foldingContainer.setOrientation(1);
        foldingContainer.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        return foldingContainer;
    }

    protected void startExpandHeightAnimation(ArrayList<Integer> viewHeights, int partAnimationDuration) {
        if (viewHeights == null || viewHeights.isEmpty()) {
            throw new IllegalArgumentException("ViewHeights array must have at least 2 elements");
        }
        ArrayList<Animation> heightAnimations = new ArrayList<Animation>();
        int fromHeight = viewHeights.get(0);
        int delay = 0;
        int animationDuration = partAnimationDuration - delay;
        for (int i = 1; i < viewHeights.size(); ++i) {
            int toHeight = fromHeight + viewHeights.get(i);
            HeightAnimation heightAnimation = new HeightAnimation((View)this, fromHeight, toHeight, animationDuration).withInterpolator((Interpolator)new DecelerateInterpolator());
            heightAnimation.setStartOffset(delay);
            heightAnimations.add(heightAnimation);
            fromHeight = toHeight;
        }
        this.createAnimationChain(heightAnimations, (View)this);
        this.startAnimation(heightAnimations.get(0));
    }

    protected void startCollapseHeightAnimation(ArrayList<Integer> viewHeights, int partAnimationDuration) {
        if (viewHeights == null || viewHeights.isEmpty()) {
            throw new IllegalArgumentException("ViewHeights array must have at least 2 elements");
        }
        ArrayList<Animation> heightAnimations = new ArrayList<Animation>();
        int fromHeight = viewHeights.get(0);
        for (int i = 1; i < viewHeights.size(); ++i) {
            int toHeight = fromHeight + viewHeights.get(i);
            heightAnimations.add(new HeightAnimation((View)this, toHeight, fromHeight, partAnimationDuration).withInterpolator((Interpolator)new DecelerateInterpolator()));
            fromHeight = toHeight;
        }
        Collections.reverse(heightAnimations);
        this.createAnimationChain(heightAnimations, (View)this);
        this.startAnimation(heightAnimations.get(0));
    }

    protected void createAnimationChain(final List<Animation> animationList, final View animationObject) {
        for (int i = 0; i < animationList.size(); ++i) {
            Animation animation = animationList.get(i);
            if (i + 1 >= animationList.size()) continue;
            final int finalI = i;
            animation.setAnimationListener((Animation.AnimationListener)new AnimationEndListener(){

                public void onAnimationEnd(Animation animation) {
                    animationObject.startAnimation((Animation)animationList.get(finalI + 1));
                }
            });
        }
    }

    protected void startFoldAnimation(ArrayList<FoldingCellView> foldingCellElements, ViewGroup foldingLayout, int part90degreeAnimationDuration, AnimationEndListener animationEndListener) {
        for (FoldingCellView foldingCellElement : foldingCellElements) {
            foldingLayout.addView((View)foldingCellElement);
        }
        Collections.reverse(foldingCellElements);
        int nextDelay = 0;
        for (int i = 0; i < foldingCellElements.size(); ++i) {
            FoldingCellView cell = foldingCellElements.get(i);
            cell.setVisibility(0);
            if (i != 0) {
                FoldAnimation foldAnimation = new FoldAnimation(FoldAnimation.FoldAnimationMode.UNFOLD_UP, this.mCameraHeight, part90degreeAnimationDuration).withStartOffset(nextDelay).withInterpolator((Interpolator)new DecelerateInterpolator());
                if (i == foldingCellElements.size() - 1) {
                    foldAnimation.setAnimationListener(animationEndListener);
                }
                cell.animateFrontView(foldAnimation);
                nextDelay += part90degreeAnimationDuration;
            }
            if (i == foldingCellElements.size() - 1) continue;
            cell.startAnimation(new FoldAnimation(FoldAnimation.FoldAnimationMode.FOLD_UP, this.mCameraHeight, part90degreeAnimationDuration).withStartOffset(nextDelay).withInterpolator((Interpolator)new DecelerateInterpolator()));
            nextDelay += part90degreeAnimationDuration;
        }
    }

    protected void startUnfoldAnimation(ArrayList<FoldingCellView> foldingCellElements, ViewGroup foldingLayout, int part90degreeAnimationDuration, AnimationEndListener animationEndListener) {
        int nextDelay = 0;
        for (int i = 0; i < foldingCellElements.size(); ++i) {
            FoldingCellView cell = foldingCellElements.get(i);
            cell.setVisibility(0);
            foldingLayout.addView((View)cell);
            if (i != 0) {
                FoldAnimation foldAnimation = new FoldAnimation(FoldAnimation.FoldAnimationMode.UNFOLD_DOWN, this.mCameraHeight, part90degreeAnimationDuration).withStartOffset(nextDelay).withInterpolator((Interpolator)new DecelerateInterpolator());
                if (i == foldingCellElements.size() - 1) {
                    foldAnimation.setAnimationListener(animationEndListener);
                }
                nextDelay += part90degreeAnimationDuration;
                cell.startAnimation(foldAnimation);
            }
            if (i == foldingCellElements.size() - 1) continue;
            cell.animateFrontView(new FoldAnimation(FoldAnimation.FoldAnimationMode.FOLD_DOWN, this.mCameraHeight, part90degreeAnimationDuration).withStartOffset(nextDelay).withInterpolator((Interpolator)new DecelerateInterpolator()));
            nextDelay += part90degreeAnimationDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeFromAttributes(Context context, AttributeSet attrs) {
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FoldingCell, 0, 0);
        try {
            this.mAnimationDuration = array.getInt(R.styleable.FoldingCell_animationDuration, 1000);
            this.mBackSideColor = array.getColor(R.styleable.FoldingCell_backSideColor, -7829368);
            this.mAdditionalFlipsCount = array.getInt(R.styleable.FoldingCell_additionalFlipsCount, 0);
            this.mCameraHeight = array.getInt(R.styleable.FoldingCell_cameraHeight, 30);
        }
        finally {
            array.recycle();
        }
    }

    protected void setStateToFolded() {
        if (this.mAnimationInProgress || !this.mUnfolded) {
            return;
        }
        View contentView = this.getChildAt(0);
        if (contentView == null) {
            return;
        }
        View titleView = this.getChildAt(1);
        if (titleView == null) {
            return;
        }
        contentView.setVisibility(8);
        titleView.setVisibility(0);
        this.mUnfolded = false;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.height = titleView.getHeight();
        this.setLayoutParams(layoutParams);
        this.requestLayout();
    }
}

