/*
 * Decompiled with CFR 0.152.
 */
package com.ramostear.captcha.core;

import com.ramostear.captcha.AbstractCaptcha;
import com.ramostear.captcha.support.CaptchaType;
import com.ramostear.captcha.thirdparty.AnimationEncoder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.awt.image.BufferedImage;
import java.io.OutputStream;

public class AnimCaptcha
extends AbstractCaptcha {
    public void render(OutputStream out) {
        char[] codes = this.text();
        Color[] colors = new Color[this.length];
        for (int i = 0; i < this.length; ++i) {
            colors[i] = this.color();
        }
        int x1 = 5;
        int y1 = AnimCaptcha.nextInt(5, this.height / 2);
        int x2 = this.width - 5;
        int y2 = AnimCaptcha.nextInt(this.height / 2, this.height - 5);
        int ctrlX = AnimCaptcha.nextInt(this.width / 4, this.width / 4 * 3);
        int ctrlY = AnimCaptcha.nextInt(5, this.height - 5);
        if (AnimCaptcha.nextInt(2) == 0) {
            int ty = y1;
            y1 = y2;
            y2 = ty;
        }
        int ctrlX1 = AnimCaptcha.nextInt(this.width / 4, this.width / 4 * 3);
        int ctrlY1 = AnimCaptcha.nextInt(5, this.height - 5);
        int[][] bezier = new int[][]{{x1, y1}, {ctrlX, ctrlY}, {ctrlX1, ctrlY1}, {x2, y2}};
        AnimationEncoder animation = new AnimationEncoder();
        animation.setQuality(180);
        animation.setDelay(100);
        animation.setRepeat(0);
        animation.start(out);
        for (int i = 0; i < this.length; ++i) {
            BufferedImage img = this.drawImage(colors, codes, i, bezier);
            animation.addFrame(img);
            img.flush();
        }
        animation.finish();
    }

    public String toBase64() {
        return this.toBase64("data:image/png;base64,");
    }

    public BufferedImage drawImage(Color[] colors, char[] chars, int index, int[][] bezier) {
        BufferedImage image = new BufferedImage(this.width, this.height, 4);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setComposite(AlphaComposite.getInstance(3, 0.1f * (float)AnimCaptcha.nextInt(10)));
        this.drawOval(g);
        this.drawLine(g);
        g.setComposite(AlphaComposite.getInstance(3, 0.1f * (float)AnimCaptcha.nextInt(10)));
        g.setStroke(new BasicStroke(1.2f, 0, 2));
        g.setColor(colors[0]);
        CubicCurve2D.Double shape = new CubicCurve2D.Double(bezier[0][0], bezier[0][1], bezier[1][0], bezier[1][1], bezier[2][0], bezier[2][1], bezier[3][0], bezier[3][1]);
        g.draw(shape);
        g.setFont(this.getFont());
        FontMetrics fontMetrics = g.getFontMetrics();
        int fw = this.width / chars.length - 2;
        int fm = (fw - (int)fontMetrics.getStringBounds("W", g).getWidth()) / 2;
        for (int i = 0; i < chars.length; ++i) {
            AlphaComposite alpha = AlphaComposite.getInstance(3, this.getAlpha(index, i));
            g.setComposite(alpha);
            g.setColor(colors[i]);
            int fY = this.height - (this.height - (int)fontMetrics.getStringBounds(String.valueOf(chars[i]), g).getHeight() >> 1);
            g.drawString(String.valueOf(chars[i]), i * fw + fm + 3, fY - 3);
        }
        g.dispose();
        return image;
    }

    private float getAlpha(int i, int j) {
        int num = i + j;
        float r = 1.0f / (float)(this.length - 1);
        float s = (float)this.length * r;
        return num >= this.length ? (float)num * r - s : (float)num * r;
    }

    public AnimCaptcha() {
    }

    public AnimCaptcha(int width, int height) {
        this();
        this.setWidth(width);
        this.setHeight(height);
    }

    public AnimCaptcha(int width, int height, int length) {
        this(width, height);
        this.setLength(length);
    }

    public AnimCaptcha(int width, int height, CaptchaType type) {
        this(width, height);
        this.setType(type);
    }

    public AnimCaptcha(int width, int height, CaptchaType type, int length) {
        this(width, height, type);
        this.setLength(length);
    }

    public AnimCaptcha(int width, int height, CaptchaType type, Font font) {
        this(width, height, type);
        this.setFont(font);
    }

    public AnimCaptcha(int width, int height, CaptchaType type, Font font, int length) {
        this(width, height, type, font);
        this.setLength(length);
    }
}

