/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThreadUtils {
    private static final Logger LOGGER;
    static final boolean VIRTUAL_THREADS_ON;
    private static final ThreadFactory THREAD_FACTORY;
    private static final Predicate<Thread> IS_VIRTUAL;

    private ThreadUtils() {
    }

    static ThreadFactory threadFactory(String prefix) {
        if (prefix == null) {
            return Executors.defaultThreadFactory();
        }
        return new NamedThreadFactory(prefix);
    }

    static ThreadFactory internalThreadFactory(String prefix) {
        if (prefix == null) {
            return THREAD_FACTORY;
        }
        return new NamedThreadFactory(THREAD_FACTORY, prefix);
    }

    static Thread newInternalThread(String name, Runnable task) {
        Thread t = THREAD_FACTORY.newThread(task);
        t.setName(name);
        return t;
    }

    static boolean isVirtual(Thread thread) {
        return IS_VIRTUAL.test(thread);
    }

    private static boolean isJava21OrMore() {
        return Runtime.version().compareTo(Runtime.Version.parse("21")) >= 0;
    }

    static {
        ThreadFactory tf;
        LOGGER = LoggerFactory.getLogger(ThreadUtils.class);
        VIRTUAL_THREADS_ON = Boolean.parseBoolean(System.getProperty("rabbitmq.stream.threads.virtual.enabled", "false"));
        LOGGER.debug("Virtual threads enabled: {}", (Object)VIRTUAL_THREADS_ON);
        LOGGER.debug("Java 21 or more: {}", (Object)ThreadUtils.isJava21OrMore());
        if (VIRTUAL_THREADS_ON && ThreadUtils.isJava21OrMore()) {
            LOGGER.debug("Using virtual threads");
            try {
                Class builderClass = Arrays.stream(Thread.class.getDeclaredClasses()).filter(c -> "Builder".equals(c.getSimpleName())).findFirst().get();
                Object builder = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]).invoke(null, new Object[0]);
                tf = (ThreadFactory)builderClass.getDeclaredMethod("factory", new Class[0]).invoke(builder, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                LOGGER.debug("Error when creating virtual thread factory on Java 21+: {}", (Object)e.getMessage());
                LOGGER.debug("Falling back to default thread factory");
                tf = Executors.defaultThreadFactory();
            }
            IS_VIRTUAL = thread -> {
                Method method = null;
                try {
                    method = Thread.class.getDeclaredMethod("isVirtual", new Class[0]);
                    return (Boolean)method.invoke(thread, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.info("Error while checking if a thread is virtual: {}", (Object)e.getMessage());
                    return false;
                }
            };
        } else {
            tf = Executors.defaultThreadFactory();
            IS_VIRTUAL = ignored -> false;
        }
        THREAD_FACTORY = tf;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadFactory backingThreadFactory;
        private final String prefix;
        private final AtomicLong count = new AtomicLong(0L);

        private NamedThreadFactory(String prefix) {
            this(Executors.defaultThreadFactory(), prefix);
        }

        private NamedThreadFactory(ThreadFactory backingThreadFactory, String prefix) {
            this.backingThreadFactory = backingThreadFactory;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.backingThreadFactory.newThread(r);
            thread.setName(this.prefix + this.count.getAndIncrement());
            return thread;
        }
    }
}

