/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StateEventSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateEventSupport.class);
    private final List<Resource.StateListener> listeners;

    StateEventSupport(List<Resource.StateListener> listeners) {
        this.listeners = List.copyOf(listeners);
    }

    void dispatch(Resource resource, Resource.State previousState, Resource.State currentState) {
        if (!this.listeners.isEmpty()) {
            DefaultContext context = new DefaultContext(resource, previousState, currentState);
            this.listeners.forEach(l -> {
                try {
                    l.handle(context);
                }
                catch (Exception e) {
                    LOGGER.warn("Error in resource listener", (Throwable)e);
                }
            });
        }
    }

    private static class DefaultContext
    implements Resource.Context {
        private final Resource resource;
        private final Resource.State previousState;
        private final Resource.State currentState;

        private DefaultContext(Resource resource, Resource.State previousState, Resource.State currentState) {
            this.resource = resource;
            this.previousState = previousState;
            this.currentState = currentState;
        }

        @Override
        public Resource resource() {
            return this.resource;
        }

        @Override
        public Resource.State previousState() {
            return this.previousState;
        }

        @Override
        public Resource.State currentState() {
            return this.currentState;
        }
    }
}

