/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.InvalidStateException;
import com.rabbitmq.stream.Resource;
import com.rabbitmq.stream.ResourceClosedException;
import com.rabbitmq.stream.impl.StateEventSupport;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

abstract class ResourceBase
implements Resource {
    private final AtomicReference<Resource.State> state = new AtomicReference();
    private final StateEventSupport stateEventSupport;

    ResourceBase(List<Resource.StateListener> listeners) {
        this.stateEventSupport = new StateEventSupport(listeners);
        this.state(Resource.State.OPENING);
    }

    protected void checkOpen() {
        Resource.State state = this.state.get();
        if (state == Resource.State.CLOSED) {
            throw new ResourceClosedException("Resource is closed", new Object[0]);
        }
        if (state != Resource.State.OPEN) {
            throw new InvalidStateException("Resource is not open, current state is %s", state.name());
        }
    }

    protected Resource.State state() {
        return this.state.get();
    }

    protected void state(Resource.State state) {
        Resource.State previousState = this.state.getAndSet(state);
        if (state != previousState) {
            this.dispatch(previousState, state);
        }
    }

    private void dispatch(Resource.State previous, Resource.State current) {
        this.stateEventSupport.dispatch(this, previous, current);
    }
}

