/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.BackOffDelayPolicy;
import com.rabbitmq.stream.NoOffsetException;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.impl.AsyncRetry;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.Utils;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OffsetTrackingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetTrackingUtils.class);

    private OffsetTrackingUtils() {
    }

    static long storedOffset(Supplier<Client> clientSupplier, String name, String stream) {
        Client.QueryOffsetResponse response;
        try {
            response = clientSupplier.get().queryOffset(name, stream);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Not possible to query offset for name %s on stream %s for now: %s", name, stream, e.getMessage()), e);
        }
        if (response.isOk()) {
            return response.getOffset();
        }
        if (response.getResponseCode() == 19) {
            throw new NoOffsetException(String.format("No offset stored for name %s on stream %s (%s)", name, stream, Utils.formatConstant(response.getResponseCode())));
        }
        throw new StreamException(String.format("QueryOffset for name %s on stream %s returned an error (%s)", name, stream, Utils.formatConstant(response.getResponseCode())), response.getResponseCode());
    }

    static void waitForOffsetToBeStored(String caller, ScheduledExecutorService scheduledExecutorService, LongSupplier offsetSupplier, String name, String stream, long expectedStoredOffset) {
        String reference = String.format("{stream=%s/name=%s}", stream, name);
        CompletableFuture<Boolean> storedTask = AsyncRetry.asyncRetry(() -> {
            try {
                long lastStoredOffset = offsetSupplier.getAsLong();
                boolean stored = lastStoredOffset == expectedStoredOffset;
                LOGGER.debug("Last stored offset from {} on {} is {}, expecting {}", new Object[]{caller, reference, lastStoredOffset, expectedStoredOffset});
                if (!stored) {
                    throw new IllegalStateException();
                }
                return true;
            }
            catch (StreamException e) {
                if (e.getCode() == 19) {
                    LOGGER.debug("No stored offset for {} on {}, expecting {}", new Object[]{caller, reference, expectedStoredOffset});
                    throw new IllegalStateException();
                }
                throw e;
            }
        }).description("Last stored offset for %s on %s must be %d", caller, reference, expectedStoredOffset).delayPolicy(BackOffDelayPolicy.fixedWithInitialDelay(Duration.ofMillis(200L), Duration.ofMillis(200L))).retry(exception -> exception instanceof IllegalStateException).scheduler(scheduledExecutorService).build();
        try {
            storedTask.get(10L, TimeUnit.SECONDS);
            LOGGER.debug("Offset {} stored ({}, {})", new Object[]{expectedStoredOffset, caller, reference});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException e) {
            LOGGER.warn("Error while checking offset has been stored", (Throwable)e);
            storedTask.cancel(true);
        }
    }
}

