/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.impl.StreamEnvironmentBuilder;
import com.rabbitmq.stream.oauth2.CredentialsManager;
import com.rabbitmq.stream.oauth2.GsonTokenParser;
import com.rabbitmq.stream.oauth2.HttpTokenRequester;
import com.rabbitmq.stream.oauth2.TokenCredentialsManager;
import java.net.http.HttpClient;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;

final class CredentialsManagerFactory {
    private static final CredentialsManager.Registration CALLBACK_DELEGATING_REGISTRATION = new CredentialsManager.Registration(){

        @Override
        public void connect(CredentialsManager.AuthenticationCallback callback) {
            callback.authenticate(null, null);
        }

        @Override
        public void close() {
        }
    };
    private static final CredentialsManager CREDENTIALS_MANAGER = (name, updateCallback) -> CALLBACK_DELEGATING_REGISTRATION;

    CredentialsManagerFactory() {
    }

    static CredentialsManager get(StreamEnvironmentBuilder.DefaultOAuth2Configuration oauth2, ScheduledExecutorService scheduledExecutorService) {
        if (oauth2 != null && oauth2.enabled()) {
            Consumer<HttpClient.Builder> clientBuilderConsumer;
            if (oauth2.tlsEnabled()) {
                SSLContext sslContext = oauth2.sslContext();
                clientBuilderConsumer = b -> b.sslContext(sslContext);
            } else {
                clientBuilderConsumer = ignored -> {};
            }
            HttpTokenRequester tokenRequester = new HttpTokenRequester(oauth2.tokenEndpointUri(), oauth2.clientId(), oauth2.clientSecret(), oauth2.grantType(), oauth2.parameters(), clientBuilderConsumer, null, new GsonTokenParser());
            return new TokenCredentialsManager(tokenRequester, scheduledExecutorService, oauth2.refreshDelayStrategy());
        }
        return CREDENTIALS_MANAGER;
    }

    static CredentialsManager.Registration get() {
        return CALLBACK_DELEGATING_REGISTRATION;
    }
}

