/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.sasl;

import com.rabbitmq.stream.sasl.AnonymousSaslMechanism;
import com.rabbitmq.stream.sasl.ExternalSaslMechanism;
import com.rabbitmq.stream.sasl.PlainSaslMechanism;
import com.rabbitmq.stream.sasl.SaslConfiguration;
import com.rabbitmq.stream.sasl.SaslMechanism;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DefaultSaslConfiguration
implements SaslConfiguration {
    public static final SaslConfiguration PLAIN = new DefaultSaslConfiguration(PlainSaslMechanism.INSTANCE.getName());
    public static final SaslConfiguration EXTERNAL = new DefaultSaslConfiguration(ExternalSaslMechanism.INSTANCE.getName());
    public static final SaslConfiguration ANONYMOUS = new DefaultSaslConfiguration(AnonymousSaslMechanism.INSTANCE.getName());
    private final Map<String, SaslMechanism> mechanisms = Collections.unmodifiableMap(Stream.of(PlainSaslMechanism.INSTANCE, ExternalSaslMechanism.INSTANCE, AnonymousSaslMechanism.INSTANCE).collect(Collectors.toMap(SaslMechanism::getName, m -> m, (k1, k2) -> k1, LinkedHashMap::new)));
    private final String mechanism;

    public DefaultSaslConfiguration() {
        this(null);
    }

    public DefaultSaslConfiguration(String mechanism) {
        if (mechanism != null && !this.mechanisms.containsKey(mechanism)) {
            throw new IllegalArgumentException(String.format("SASL mechanism not supported: %s. Supported mechanisms: %s.", mechanism, String.join((CharSequence)", ", this.mechanisms.keySet())));
        }
        this.mechanism = mechanism;
    }

    @Override
    public SaslMechanism getSaslMechanism(List<String> mechanisms) {
        List<Object> list = mechanisms = mechanisms == null ? Collections.emptyList() : mechanisms;
        if (this.mechanism == null) {
            for (String serverMechanism : mechanisms) {
                SaslMechanism match = this.mechanisms.get(serverMechanism);
                if (match == null) continue;
                return match;
            }
            throw new IllegalStateException(String.format("Unable to agree on a SASL mechanism. Client: %s / server %s.", String.join((CharSequence)", ", this.mechanisms.keySet()), String.join((CharSequence)", ", mechanisms)));
        }
        if (mechanisms.contains(this.mechanism)) {
            return this.mechanisms.get(this.mechanism);
        }
        throw new IllegalStateException(String.format("Unable to agree on a SASL mechanism. Client: %s / server %s.", this.mechanism, String.join((CharSequence)", ", mechanisms)));
    }
}

