/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.ByteCapacity;
import com.rabbitmq.stream.StreamCreator;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.Utils;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class StreamStreamCreator
implements StreamCreator {
    private final StreamEnvironment environment;
    private final Client.StreamParametersBuilder streamParametersBuilder = new Client.StreamParametersBuilder().leaderLocator(StreamCreator.LeaderLocator.LEAST_LEADERS);
    private String name;
    private DefaultSuperStreamConfiguration superStreamConfiguration;

    StreamStreamCreator(StreamEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public StreamCreator stream(String stream) {
        this.name = stream;
        return this;
    }

    @Override
    public StreamCreator name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public StreamCreator maxLengthBytes(ByteCapacity byteCapacity) {
        this.streamParametersBuilder.maxLengthBytes(byteCapacity);
        return this;
    }

    @Override
    public StreamCreator maxSegmentSizeBytes(ByteCapacity byteCapacity) {
        if (byteCapacity != null && byteCapacity.compareTo(MAX_SEGMENT_SIZE) > 0) {
            throw new IllegalArgumentException("The maximum segment size cannot be more than " + MAX_SEGMENT_SIZE);
        }
        this.streamParametersBuilder.maxSegmentSizeBytes(byteCapacity);
        return this;
    }

    @Override
    public StreamCreator maxAge(Duration maxAge) {
        this.streamParametersBuilder.maxAge(maxAge);
        return this;
    }

    @Override
    public StreamCreator leaderLocator(StreamCreator.LeaderLocator leaderLocator) {
        this.streamParametersBuilder.leaderLocator(leaderLocator);
        return this;
    }

    @Override
    public StreamCreator filterSize(int size) {
        this.streamParametersBuilder.filterSize(size);
        return this;
    }

    @Override
    public StreamCreator.SuperStreamConfiguration superStream() {
        if (this.superStreamConfiguration == null) {
            this.superStreamConfiguration = new DefaultSuperStreamConfiguration(this);
        }
        return this.superStreamConfiguration;
    }

    @Override
    public void create() {
        Function<Client, Client.Response> function;
        boolean superStream;
        if (this.name == null) {
            throw new IllegalArgumentException("Stream name cannot be null");
        }
        boolean bl = superStream = this.superStreamConfiguration != null;
        if (superStream) {
            List bindingKeys;
            List partitions;
            if (this.superStreamConfiguration.bindingKeys == null) {
                partitions = IntStream.range(0, this.superStreamConfiguration.partitions).mapToObj(i -> this.name + "-" + i).collect(Collectors.toList());
                bindingKeys = IntStream.range(0, this.superStreamConfiguration.partitions).mapToObj(String::valueOf).collect(Collectors.toList());
            } else {
                partitions = this.superStreamConfiguration.bindingKeys.stream().map(rk -> this.name + "-" + rk).collect(Collectors.toList());
                bindingKeys = this.superStreamConfiguration.bindingKeys;
            }
            function = Utils.namedFunction(c -> c.createSuperStream(this.name, partitions, bindingKeys, this.streamParametersBuilder.build()), "Creation of super stream '%s'", this.name);
        } else {
            function = Utils.namedFunction(c -> c.create(this.name, this.streamParametersBuilder.build()), "Creation of stream '%s'", this.name);
        }
        this.environment.maybeInitializeLocator();
        Client.Response response = this.environment.locatorOperation(function);
        if (!response.isOk() && response.getResponseCode() != 5) {
            String label = superStream ? "super stream" : "stream";
            throw new StreamException("Error while creating " + label + " '" + this.name + "' (" + Utils.formatConstant(response.getResponseCode()) + ")", response.getResponseCode());
        }
    }

    private static class DefaultSuperStreamConfiguration
    implements StreamCreator.SuperStreamConfiguration {
        private final StreamCreator creator;
        private int partitions = 3;
        private List<String> bindingKeys = null;

        private DefaultSuperStreamConfiguration(StreamCreator creator) {
            this.creator = creator;
        }

        @Override
        public StreamCreator.SuperStreamConfiguration partitions(int partitions) {
            if (partitions <= 0) {
                throw new IllegalArgumentException("The number of partitions must be greater than 0");
            }
            this.partitions = partitions;
            this.bindingKeys = null;
            return this;
        }

        @Override
        public StreamCreator.SuperStreamConfiguration bindingKeys(String ... bindingKeys) {
            if (bindingKeys == null || bindingKeys.length == 0) {
                throw new IllegalArgumentException("There must be at least 1 binding key");
            }
            this.bindingKeys = Arrays.asList(bindingKeys);
            this.partitions = -1;
            return this;
        }

        @Override
        public StreamCreator creator() {
            return this.creator;
        }
    }
}

