/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.codec;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageBuilder;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.codec.SwiftMqCodec;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressString;
import com.swiftmq.amqp.v100.generated.messaging.message_format.ApplicationProperties;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Data;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageAnnotations;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdBinary;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdString;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdUlong;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdUuid;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Properties;
import com.swiftmq.amqp.v100.generated.transport.definitions.SequenceNo;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPByte;
import com.swiftmq.amqp.v100.types.AMQPChar;
import com.swiftmq.amqp.v100.types.AMQPDouble;
import com.swiftmq.amqp.v100.types.AMQPFloat;
import com.swiftmq.amqp.v100.types.AMQPInt;
import com.swiftmq.amqp.v100.types.AMQPLong;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPShort;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPTimestamp;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedByte;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import com.swiftmq.amqp.v100.types.AMQPUnsignedShort;
import com.swiftmq.amqp.v100.types.AMQPUuid;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

class SwiftMqMessageBuilder
implements MessageBuilder {
    private boolean hasPublishingId = false;
    private long publishingId = 0L;
    private final AMQPMessage outboundMessage = new AMQPMessage();
    private SwiftMqPropertiesBuilder propertiesBuilder;
    private SwiftMqApplicationPropertiesBuilder applicationPropertiesBuilder;
    private SwiftMqMessageAnnotationsBuilder messageAnnotationsBuilder;
    private final AtomicBoolean built = new AtomicBoolean(false);

    SwiftMqMessageBuilder() {
    }

    @Override
    public Message build() {
        if (this.built.compareAndSet(false, true)) {
            if (this.messageAnnotationsBuilder != null) {
                try {
                    this.outboundMessage.setMessageAnnotations(new MessageAnnotations(this.messageAnnotationsBuilder.map));
                }
                catch (IOException e) {
                    throw new StreamException("Error while setting message annotations", e);
                }
            }
            if (this.propertiesBuilder != null) {
                this.outboundMessage.setProperties(this.propertiesBuilder.properties);
            }
            if (this.applicationPropertiesBuilder != null) {
                try {
                    this.outboundMessage.setApplicationProperties(new ApplicationProperties(this.applicationPropertiesBuilder.map));
                }
                catch (IOException e) {
                    throw new StreamException("Error while setting application properties", e);
                }
            }
            if (this.outboundMessage.getData() == null) {
                this.outboundMessage.addData(SwiftMqCodec.EMPTY_BODY);
            }
            return new SwiftMqCodec.SwiftMqAmqpMessageWrapper(this.hasPublishingId, this.publishingId, this.outboundMessage);
        }
        throw new IllegalStateException("A message builder can build only one message");
    }

    @Override
    public MessageBuilder publishingId(long publishingId) {
        this.publishingId = publishingId;
        this.hasPublishingId = true;
        return this;
    }

    @Override
    public MessageBuilder.PropertiesBuilder properties() {
        if (this.propertiesBuilder == null) {
            this.propertiesBuilder = new SwiftMqPropertiesBuilder(this);
        }
        return this.propertiesBuilder;
    }

    @Override
    public MessageBuilder.ApplicationPropertiesBuilder applicationProperties() {
        if (this.applicationPropertiesBuilder == null) {
            this.applicationPropertiesBuilder = new SwiftMqApplicationPropertiesBuilder(this);
        }
        return this.applicationPropertiesBuilder;
    }

    @Override
    public MessageBuilder.MessageAnnotationsBuilder messageAnnotations() {
        if (this.messageAnnotationsBuilder == null) {
            this.messageAnnotationsBuilder = new SwiftMqMessageAnnotationsBuilder(this);
        }
        return this.messageAnnotationsBuilder;
    }

    @Override
    public MessageBuilder addData(byte[] data) {
        this.outboundMessage.addData(new Data(data));
        return this;
    }

    private static class SwiftMqMessageAnnotationsBuilder
    extends AmqpMapBuilderSupport
    implements MessageBuilder.MessageAnnotationsBuilder {
        private static final Function<String, AMQPType> KEY_MAKER = key -> new AMQPSymbol(key);
        private final MessageBuilder messageBuilder;

        private SwiftMqMessageAnnotationsBuilder(MessageBuilder messageBuilder) {
            super(KEY_MAKER);
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, boolean value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, byte value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, short value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, int value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, long value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, byte value) {
            this.addEntryUnsigned(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, short value) {
            this.addEntryUnsigned(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, int value) {
            this.addEntryUnsigned(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, long value) {
            this.addEntryUnsigned(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, float value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, double value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal32(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal64(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal128(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, char value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryTimestamp(String key, long value) {
            this.addEntryTimestamp(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, UUID value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, byte[] value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, String value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entrySymbol(String key, String value) {
            this.addEntrySymbol(key, value);
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }

    private static class SwiftMqApplicationPropertiesBuilder
    extends AmqpMapBuilderSupport
    implements MessageBuilder.ApplicationPropertiesBuilder {
        private static final Function<String, AMQPType> KEY_MAKER = key -> new AMQPString(key);
        private final MessageBuilder messageBuilder;

        private SwiftMqApplicationPropertiesBuilder(MessageBuilder messageBuilder) {
            super(KEY_MAKER);
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, boolean value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, byte value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, short value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, int value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, long value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, byte value) {
            this.addEntryUnsigned(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, short value) {
            this.addEntryUnsigned(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, int value) {
            this.addEntryUnsigned(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, long value) {
            this.addEntryUnsigned(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, float value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, double value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal32(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal64(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal128(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, char value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryTimestamp(String key, long value) {
            this.addEntryTimestamp(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, UUID value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, byte[] value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, String value) {
            this.addEntry(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entrySymbol(String key, String value) {
            this.addEntrySymbol(key, value);
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }

    private static class AmqpMapBuilderSupport {
        protected final Map<AMQPType, AMQPType> map = new LinkedHashMap<AMQPType, AMQPType>();
        private final Function<String, AMQPType> keyMaker;

        private AmqpMapBuilderSupport(Function<String, AMQPType> keyMaker) {
            this.keyMaker = keyMaker;
        }

        protected void addEntry(String key, boolean value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPBoolean(value));
        }

        protected void addEntry(String key, byte value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPByte(value));
        }

        protected void addEntry(String key, short value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPShort((int)value));
        }

        protected void addEntry(String key, int value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPInt(value));
        }

        protected void addEntry(String key, long value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPLong(value));
        }

        protected void addEntryUnsigned(String key, byte value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPUnsignedByte((int)value));
        }

        protected void addEntryUnsigned(String key, short value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPUnsignedShort((int)value));
        }

        protected void addEntryUnsigned(String key, int value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPUnsignedInt((long)value));
        }

        protected void addEntryUnsigned(String key, long value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPUnsignedLong(value));
        }

        protected void addEntry(String key, float value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPFloat(value));
        }

        protected void addEntry(String key, double value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPDouble(value));
        }

        protected void addEntry(String key, char value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPChar((int)value));
        }

        protected void addEntryTimestamp(String key, long value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)new AMQPTimestamp(value));
        }

        protected void addEntry(String key, UUID value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)(value == null ? AMQPNull.NULL : new AMQPUuid(value)));
        }

        protected void addEntry(String key, byte[] value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)(value == null ? AMQPNull.NULL : new AMQPBinary(value)));
        }

        protected void addEntry(String key, String value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)(value == null ? AMQPNull.NULL : new AMQPString(value)));
        }

        protected void addEntrySymbol(String key, String value) {
            this.map.put(this.keyMaker.apply(key), (AMQPType)(value == null ? AMQPNull.NULL : new AMQPSymbol(value)));
        }
    }

    private static class SwiftMqPropertiesBuilder
    implements MessageBuilder.PropertiesBuilder {
        private final Properties properties = new Properties();
        private final MessageBuilder messageBuilder;

        private SwiftMqPropertiesBuilder(MessageBuilder messageBuilder) {
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(String id) {
            this.properties.setMessageId((MessageIdIF)new MessageIdString(id));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(long id) {
            this.properties.setMessageId((MessageIdIF)new MessageIdUlong(id));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(byte[] id) {
            this.properties.setMessageId((MessageIdIF)new MessageIdBinary(id));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(UUID id) {
            this.properties.setMessageId((MessageIdIF)new MessageIdUuid(id));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder userId(byte[] userId) {
            this.properties.setUserId(new AMQPBinary(userId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder to(String address) {
            this.properties.setTo((AddressIF)new AddressString(address));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder subject(String subject) {
            this.properties.setSubject(new AMQPString(subject));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder replyTo(String replyTo) {
            this.properties.setReplyTo((AddressIF)new AddressString(replyTo));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(String correlationId) {
            this.properties.setCorrelationId((MessageIdIF)new MessageIdString(correlationId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(long correlationId) {
            this.properties.setCorrelationId((MessageIdIF)new MessageIdUlong(correlationId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(byte[] correlationId) {
            this.properties.setCorrelationId((MessageIdIF)new MessageIdBinary(correlationId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(UUID correlationId) {
            this.properties.setCorrelationId((MessageIdIF)new MessageIdUuid(correlationId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder contentType(String contentType) {
            this.properties.setContentType(new AMQPSymbol(contentType));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder contentEncoding(String contentEncoding) {
            this.properties.setContentEncoding(new AMQPSymbol(contentEncoding));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder absoluteExpiryTime(long absoluteExpiryTime) {
            this.properties.setAbsoluteExpiryTime(new AMQPTimestamp(absoluteExpiryTime));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder creationTime(long creationTime) {
            this.properties.setCreationTime(new AMQPTimestamp(creationTime));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder groupId(String groupId) {
            this.properties.setGroupId(new AMQPString(groupId));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder groupSequence(long groupSequence) {
            this.properties.setGroupSequence(new SequenceNo(groupSequence));
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder replyToGroupId(String replyToGroupId) {
            this.properties.setReplyToGroupId(new AMQPString(replyToGroupId));
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }
}

