/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;

public class WhiteListObjectInputStream
extends ObjectInputStream {
    private static final ClassLoader FALLBACK_CLASS_LOADER = WhiteListObjectInputStream.class.getClassLoader();
    public static final List<String> DEFAULT_TRUSTED_PACKAGES;
    private final ClassLoader inputStreamLoader;
    private List<String> trustedPackages = DEFAULT_TRUSTED_PACKAGES;

    public WhiteListObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.inputStreamLoader = in.getClass().getClassLoader();
    }

    public WhiteListObjectInputStream(InputStream in, List<String> trustedPackages) throws IOException {
        super(in);
        this.inputStreamLoader = in.getClass().getClassLoader();
        this.trustedPackages = trustedPackages;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = this.load(desc.getName(), threadLoader, this.inputStreamLoader);
        this.checkWhiteList(clazz);
        return clazz;
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] ifaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            ifaces[i] = this.load(interfaces[i], cl);
        }
        Class<?> clazz = null;
        try {
            clazz = Proxy.getProxyClass(cl, ifaces);
        }
        catch (IllegalArgumentException e) {
            try {
                clazz = Proxy.getProxyClass(this.inputStreamLoader, ifaces);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                clazz = Proxy.getProxyClass(FALLBACK_CLASS_LOADER, ifaces);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            this.checkWhiteList(clazz);
            return clazz;
        }
        throw new ClassNotFoundException(null);
    }

    public void addTrustedPackage(String trustedPackage) {
        this.trustedPackages.add(trustedPackage);
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    public void setTrustedPackages(List<String> trustedPackages) {
        this.trustedPackages = trustedPackages;
    }

    public boolean shouldTrustAllPackages() {
        return this.trustedPackages != null && this.trustedPackages.size() == 1 && this.trustedPackages.get(0).equals("*");
    }

    private void checkWhiteList(Class clazz) throws ClassNotFoundException {
        if (clazz.isPrimitive()) {
            return;
        }
        if (clazz.getPackage() != null && !this.shouldTrustAllPackages()) {
            boolean result = false;
            String p = clazz.getPackage().getName();
            for (String pkg : this.trustedPackages) {
                if (!p.equals(pkg) && !p.startsWith(pkg)) continue;
                result = true;
                break;
            }
            if (!result) {
                throw new ClassNotFoundException("Class " + String.valueOf(clazz) + " is not trusted to be deserialized as ObjectMessage payload. Trusted packages can be configured via -Dcom.rabbitmq.jms.TrustedPackagesPrefixes  or RMQConnectionFactory#setTrustedPackages.");
            }
        }
    }

    private Class<?> load(String className, ClassLoader ... cls) throws ClassNotFoundException {
        for (ClassLoader cl : cls) {
            try {
                return Class.forName(className, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return Class.forName(className, false, FALLBACK_CLASS_LOADER);
    }

    static {
        String viaProperty = System.getProperty("com.rabbitmq.jms.TrustedPackagesPrefixes", "*");
        DEFAULT_TRUSTED_PACKAGES = Arrays.asList(viaProperty.split(","));
    }
}

