/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.util;

import java.util.concurrent.TimeUnit;

public class TimeTracker {
    private final long timeoutNanos;
    private final long startNanos;
    private volatile boolean timed_out;
    public static final TimeTracker ZERO = new TimeTracker(0L);

    public TimeTracker(long timeout, TimeUnit unit) {
        this(unit.toNanos(timeout));
    }

    public TimeTracker(TimeTracker timeTracker) {
        this(timeTracker.timeoutNanos());
    }

    public TimeTracker() {
        this(Long.MAX_VALUE);
    }

    long timeoutNanos() {
        return this.timeoutNanos;
    }

    private TimeTracker(long timeoutNanos) {
        this.timeoutNanos = timeoutNanos;
        this.startNanos = System.nanoTime();
        this.timed_out = timeoutNanos <= 0L;
    }

    private long internalRemaining() {
        if (this.timed_out) {
            return 0L;
        }
        long rem = this.timeoutNanos - (System.nanoTime() - this.startNanos);
        if (rem <= 0L) {
            this.timed_out = true;
            return 0L;
        }
        return rem;
    }

    public long remainingNanos() {
        return this.internalRemaining();
    }

    public long remainingMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.internalRemaining());
    }

    public void timedWait(Object lock) throws InterruptedException {
        TimeUnit.NANOSECONDS.timedWait(lock, this.internalRemaining());
    }

    public boolean timedOut() {
        return this.timed_out || this.internalRemaining() == 0L;
    }

    public String toString() {
        long timeoutMillis = TimeUnit.NANOSECONDS.toMillis(this.timeoutNanos);
        long internalTimeoutMillis = TimeUnit.NANOSECONDS.toMillis(this.internalRemaining());
        return "TimeTracker(" + timeoutMillis + "ms set, " + internalTimeoutMillis + "ms rem)";
    }
}

