/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.sql.SqlTokenValueType;
import java.util.regex.Pattern;

enum SqlTokenType {
    WS(false, "whitespace", "\\s+"),
    LIKE(true, "like", "[Ll][Ii][Kk][Ee](?![a-zA-Z0-9_$.])"),
    NOT_LIKE(true, "not_like", "[Nn][Oo][Tt]\\s+[Ll][Ii][Kk][Ee](?![a-zA-Z0-9_$.])"),
    IN(true, "in", "[Ii][Nn](?![a-zA-Z0-9_$.])"),
    NOT_IN(true, "not_in", "[Nn][Oo][Tt]\\s+[Ii][Nn](?![a-zA-Z0-9_$.])"),
    NULL(true, "is_null", "[Ii][Ss]\\s+[Nn][Uu][Ll][Ll](?![a-zA-Z0-9_$.])"),
    NOT_NULL(true, "not_null", "[Ii][Ss]\\s+[Nn][Oo][Tt]\\s+[Nn][Uu][Ll][Ll](?![a-zA-Z0-9_$.])"),
    BETWEEN(true, "between", "[Bb][Ee][Tt][Ww][Ee][Ee][Nn](?![a-zA-Z0-9_$.])"),
    NOT_BETWEEN(true, "not_between", "[Nn][Oo][Tt]\\s+[Bb][Ee][Tt][Ww][Ee][Ee][Nn](?![a-zA-Z0-9_$.])"),
    AND(true, "and", "[Aa][Nn][Dd](?![a-zA-Z0-9_$.])"),
    OR(true, "or", "[Oo][Rr](?![a-zA-Z0-9_$.])"),
    NOT(true, "not", "[Nn][Oo][Tt](?![a-zA-Z0-9_$.])"),
    ESCAPE(true, "ESCAPE", "[Ee][Ss][Cc][Aa][Pp][Ee](?![a-zA-Z0-9_$.])"),
    TRUE(true, "true", "[Tt][Rr][Uu][Ee](?![a-zA-Z0-9_$.])"),
    FALSE(true, "false", "[Ff][Aa][Ll][Ss][Ee](?![a-zA-Z0-9_$.])"),
    CMP_EQ(true, "=", "="),
    CMP_NEQ(true, "<>", "<>"),
    CMP_LTEQ(true, "<=", "<="),
    CMP_GTEQ(true, ">=", ">="),
    CMP_LT(true, "<", "<"),
    CMP_GT(true, ">", ">"),
    OP_PLUS(true, "+", "\\+"),
    OP_MINUS(true, "-", "-"),
    OP_MULT(true, "*", "\\*"),
    OP_DIV(true, "/", "/"),
    COMMA(true, ",", ","),
    LP(true, "(", "\\("),
    RP(true, ")", "\\)"),
    IDENT(true, "ident", "[a-zA-Z_$][a-zA-Z0-9_$.]*", SqlTokenValueType.IDENT),
    STRING(true, "string", "'([^']|'')*'", SqlTokenValueType.STRING),
    FLOAT(true, "float", "[0-9]+(\\.[0-9]+[Ee][-+]?[0-9]+|(\\.([Ee][-+]?[0-9]+)|[Ee][-+]?[0-9]+)|(\\.[0-9]*)?[fFdD]|\\.[0-9]*)", SqlTokenValueType.FLOAT),
    INT(true, "integer", "[0-9]+", SqlTokenValueType.LONG),
    HEX(true, "hex", "0x[0-9a-fA-F]+", SqlTokenValueType.HEX),
    LIST(false, "list", null, SqlTokenValueType.LIST),
    TEST(false, "\u2039\u203a", null, SqlTokenValueType.NO_VALUE);

    private boolean include;
    private String opCode;
    private Pattern pattern;
    private SqlTokenValueType vtype;

    private SqlTokenType(boolean isToken, String opCode, String regex) {
        this(isToken, opCode, regex, SqlTokenValueType.NO_VALUE);
    }

    private SqlTokenType(boolean include, String opCode, String regex, SqlTokenValueType vtype) {
        this.include = include;
        this.opCode = opCode;
        this.vtype = vtype;
        this.pattern = regex == null ? null : Pattern.compile(regex);
    }

    String opCode() {
        return this.opCode;
    }

    SqlTokenValueType valueType() {
        return this.vtype;
    }

    boolean include() {
        return this.include;
    }

    Pattern pattern() {
        return this.pattern;
    }
}

