/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.Parser;
import com.rabbitmq.jms.parse.sql.SqlParseTree;
import com.rabbitmq.jms.parse.sql.SqlProduction;
import com.rabbitmq.jms.parse.sql.SqlTokenStream;
import com.rabbitmq.jms.parse.sql.SqlTreeNode;

public class SqlParser
implements Parser<SqlTreeNode> {
    private final boolean parseOk;
    private final String errorMessage;
    private final SqlParseTree parseTree;

    public SqlParser(SqlTokenStream tokenStream) {
        if ("".equals(tokenStream.getResidue())) {
            this.parseTree = SqlProduction.ROOT.parse(tokenStream);
            if (tokenStream.moreTokens()) {
                this.parseOk = false;
                this.errorMessage = String.format("Terminated before end of stream; next token is: '%s' at index: %s.", tokenStream.readToken(), tokenStream.position());
            } else if (this.parseTree == null) {
                this.parseOk = false;
                this.errorMessage = "No parse tree produced.";
            } else {
                this.parseOk = true;
                this.errorMessage = null;
            }
        } else {
            this.parseOk = false;
            this.errorMessage = "Unrecognised syntax after: '" + tokenStream.getResidue() + "'";
            this.parseTree = null;
        }
    }

    public SqlParseTree parse() {
        return this.parseTree;
    }

    @Override
    public boolean parseOk() {
        return this.parseOk;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

