/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client.message;

import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.util.RMQByteArrayOutputStream;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.RMQMessageFormatException;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RMQBytesMessage
extends RMQMessage
implements BytesMessage {
    private volatile boolean reading;
    private volatile transient byte[] buf;
    private volatile transient int pos;
    private transient RMQByteArrayOutputStream bout;

    public RMQBytesMessage() {
        this(false);
    }

    private RMQBytesMessage(boolean reading) {
        this.reading = reading;
        if (!reading) {
            this.bout = new RMQByteArrayOutputStream(DEFAULT_MESSAGE_BODY_SIZE);
        }
    }

    public boolean readBoolean() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 1 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        return Bits.getBoolean(this.buf, this.pos++);
    }

    public byte readByte() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 1 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        return this.buf[this.pos++];
    }

    public int readUnsignedByte() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 1 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public short readShort() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 2 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        short s = Bits.getShort(this.buf, this.pos);
        this.pos += 2;
        return s;
    }

    public int readUnsignedShort() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 2 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        short s = Bits.getShort(this.buf, this.pos);
        this.pos += 2;
        return s & 0xFFFF;
    }

    public char readChar() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 2 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        char ch = Bits.getChar(this.buf, this.pos);
        this.pos += 2;
        return ch;
    }

    public int readInt() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 4 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        int i = Bits.getInt(this.buf, this.pos);
        this.pos += 4;
        return i;
    }

    public long readLong() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 8 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        long l = Bits.getLong(this.buf, this.pos);
        this.pos += 8;
        return l;
    }

    public float readFloat() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 4 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        float flt = Bits.getFloat(this.buf, this.pos);
        this.pos += 4;
        return flt;
    }

    public double readDouble() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.pos + 8 > this.buf.length) {
            throw new MessageEOFException("Message EOF");
        }
        double dbl = Bits.getDouble(this.buf, this.pos);
        this.pos += 8;
        return dbl;
    }

    public String readUTF() throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        int posOfUtfItem = this.pos;
        int lenUtfBytes = this.readUnsignedShort();
        this.pos = posOfUtfItem;
        int utfItemLen = 2 + lenUtfBytes;
        if (posOfUtfItem + utfItemLen > this.buf.length) {
            throw new MessageFormatException("Not enough bytes in message body for UTF object");
        }
        byte[] utfBuf = new byte[utfItemLen];
        System.arraycopy(this.buf, posOfUtfItem, utfBuf, 0, utfItemLen);
        try {
            String str = new DataInputStream(new ByteArrayInputStream(utfBuf)).readUTF();
            this.pos += utfItemLen;
            return str;
        }
        catch (IOException ioe) {
            throw new RMQMessageFormatException("UTF String invalid format", ioe);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos < this.buf.length) {
            int readLen = Math.min(length, this.buf.length - this.pos);
            System.arraycopy(this.buf, this.pos, value, 0, readLen);
            this.pos += readLen;
            return readLen;
        }
        return -1;
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeByte(value);
    }

    public void writeShort(short value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeShort(value);
    }

    public void writeChar(char value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeChar(value);
    }

    public void writeInt(int value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeLong(value);
    }

    public void writeFloat(float value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeFloat(value);
    }

    public void writeDouble(double value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeDouble(value);
    }

    public void writeUTF(String value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this.bout.writeUTF(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        try {
            this.bout.write(value);
        }
        catch (IOException e) {
            throw new RMQJMSException(e);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        if (value == null) {
            throw new MessageFormatException("Null byte array");
        }
        if (offset >= value.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bout.write(value, offset, length);
    }

    public void writeObject(Object value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        RMQBytesMessage.writePrimitiveData(value, this.bout);
    }

    public void reset() throws JMSException {
        if (this.reading) {
            this.pos = 0;
        } else {
            this.buf = this.bout != null ? this.bout.toByteArray() : new byte[0];
            this.pos = 0;
            this.reading = true;
            this.bout = null;
        }
    }

    public long getBodyLength() throws JMSException {
        return this.reading ? (long)this.buf.length : (long)this.bout.size();
    }

    @Override
    public void clearBodyInternal() throws JMSException {
        this.bout = new RMQByteArrayOutputStream(DEFAULT_MESSAGE_BODY_SIZE);
        this.pos = 0;
        this.buf = null;
        this.reading = false;
    }

    private byte[] getByteArray() {
        if (this.reading) {
            return this.buf;
        }
        return this.bout.toByteArray();
    }

    @Override
    protected void writeBody(ObjectOutput oOut, ByteArrayOutputStream bout) throws IOException {
        byte[] buf = this.getByteArray();
        bout.write(buf);
    }

    @Override
    protected void writeAmqpBody(ByteArrayOutputStream baos) throws IOException {
        byte[] buf = this.getByteArray();
        baos.write(buf);
    }

    @Override
    protected void readBody(ObjectInput inputStream, ByteArrayInputStream bin) throws IOException, ClassNotFoundException {
        this.buf = new byte[bin.available()];
        bin.read(this.buf);
        this.reading = true;
        this.pos = 0;
    }

    @Override
    protected void readAmqpBody(byte[] barr) {
        this.buf = barr;
        this.reading = true;
        this.pos = 0;
    }

    private static void writePrimitiveData(Object s, RMQByteArrayOutputStream out) throws JMSException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s instanceof Boolean) {
            out.writeBoolean((Boolean)s);
        } else if (s instanceof Byte) {
            out.writeByte((Byte)s);
        } else if (s instanceof Short) {
            out.writeShort((Short)s);
        } else if (s instanceof Integer) {
            out.writeInt((Integer)s);
        } else if (s instanceof Long) {
            out.writeLong((Long)s);
        } else if (s instanceof Float) {
            out.writeFloat(((Float)s).floatValue());
        } else if (s instanceof Double) {
            out.writeDouble((Double)s);
        } else if (s instanceof String) {
            out.writeUTF((String)s);
        } else if (s instanceof Character) {
            out.writeChar(((Character)s).charValue());
        } else if (s instanceof byte[]) {
            out.write((byte[])s, 0, ((byte[])s).length);
        } else {
            throw new MessageFormatException(s + " is not a recognized writable type.");
        }
    }

    public static RMQMessage recreate(BytesMessage msg) throws JMSException {
        msg.reset();
        long bodyLength = msg.getBodyLength();
        int bodySize = (int)Math.min(Math.max(0L, bodyLength), Integer.MAX_VALUE);
        if (bodyLength != (long)bodySize) {
            throw new JMSException(String.format("BytesMessage body invalid length (%s). Negative or too large.", bodyLength));
        }
        try {
            RMQBytesMessage rmqBMsg = new RMQBytesMessage();
            RMQMessage.copyAttributes(rmqBMsg, (Message)msg);
            byte[] byteArray = new byte[bodySize];
            if (bodyLength > 0L && bodySize != msg.readBytes(byteArray, bodySize)) {
                throw new MessageEOFException("Cannot read all of non-RMQ Message body.");
            }
            rmqBMsg.writeBytes(byteArray);
            rmqBMsg.reset();
            return rmqBMsg;
        }
        catch (OutOfMemoryError e) {
            throw new RMQJMSException("Body too large for conversion to RMQMessage.", e);
        }
    }

    public boolean isBodyAssignableTo(Class c) {
        return this.buf == null ? true : c.isAssignableFrom(byte[].class);
    }

    @Override
    protected <T> T doGetBody(Class<T> c) throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        this.reset();
        if (this.buf == null) {
            return null;
        }
        byte[] copy = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, copy, 0, this.buf.length);
        return (T)copy;
    }

    @Override
    public boolean isAmqpWritable() {
        return true;
    }

    private static abstract class Bits {
        static final int NUM_BYTES_IN_BOOLEAN = 1;
        static final int NUM_BYTES_IN_CHAR = 2;
        static final int NUM_BYTES_IN_SHORT = 2;
        static final int NUM_BYTES_IN_INT = 4;
        static final int NUM_BYTES_IN_FLOAT = 4;
        static final int NUM_BYTES_IN_LONG = 8;
        static final int NUM_BYTES_IN_DOUBLE = 8;

        private Bits() {
        }

        static boolean getBoolean(byte[] b, int off) {
            return b[off] != 0;
        }

        static char getChar(byte[] b, int off) {
            return (char)((b[off + 1] & 0xFF) + (b[off] << 8));
        }

        static short getShort(byte[] b, int off) {
            return (short)((b[off + 1] & 0xFF) + (b[off] << 8));
        }

        static int getInt(byte[] b, int off) {
            return (b[off + 3] & 0xFF) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + (b[off] << 24);
        }

        static float getFloat(byte[] b, int off) {
            return Float.intBitsToFloat(Bits.getInt(b, off));
        }

        static long getLong(byte[] b, int off) {
            return ((long)b[off + 7] & 0xFFL) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off] << 56);
        }

        static double getDouble(byte[] b, int off) {
            return Double.longBitsToDouble(Bits.getLong(b, off));
        }
    }
}

