/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.jms.client.Utils;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class RmqJmsConsumer
implements JMSConsumer {
    private final Session session;
    private final MessageConsumer consumer;
    private final Queue<Message> failedBodyConversionMessages = new ConcurrentLinkedQueue<Message>();

    RmqJmsConsumer(Session session, MessageConsumer consumer) {
        this.session = session;
        this.consumer = consumer;
    }

    public String getMessageSelector() {
        return Utils.wrap(() -> this.consumer.getMessageSelector());
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        return Utils.wrap(() -> this.consumer.getMessageListener());
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        Utils.wrap(() -> this.consumer.setMessageListener(listener));
    }

    public Message receive() {
        return Utils.wrap(() -> this.consumer.receive());
    }

    public Message receive(long timeout) {
        return Utils.wrap(() -> this.consumer.receive(timeout));
    }

    public Message receiveNoWait() {
        return Utils.wrap(() -> this.consumer.receiveNoWait());
    }

    public void close() {
        Utils.wrap(() -> this.consumer.close());
    }

    public <T> T receiveBody(Class<T> c) {
        Message message = this.failedBodyConversionMessages.poll();
        if (message == null) {
            message = this.receive();
        }
        return this.handleBodyConversion(message, c);
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        Message message = this.failedBodyConversionMessages.poll();
        if (message == null) {
            message = this.receive(timeout);
        }
        return this.handleBodyConversion(message, c);
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        Message message = this.failedBodyConversionMessages.poll();
        if (message == null) {
            message = this.receiveNoWait();
        }
        return this.handleBodyConversion(message, c);
    }

    private <T> T handleBodyConversion(Message message, Class<T> c) {
        return (T)Utils.wrap(() -> {
            if (message == null) {
                return null;
            }
            if (message instanceof StreamMessage) {
                if (this.isAutoAckOrDupsOk()) {
                    this.failedBodyConversionMessages.offer(message);
                }
                throw new MessageFormatRuntimeException("Not possible to call receiveBody on a StreamMessage");
            }
            try {
                return message.getBody(c);
            }
            catch (MessageFormatException e) {
                if (this.isAutoAckOrDupsOk()) {
                    this.failedBodyConversionMessages.offer(message);
                }
                throw new MessageFormatRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
        });
    }

    private boolean isAutoAckOrDupsOk() throws JMSException {
        return this.session.getAcknowledgeMode() == 1 || this.session.getAcknowledgeMode() == 3;
    }
}

