/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.impl.Version;
import com.rabbitmq.jms.client.GenericVersion;
import java.util.Enumeration;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;

public class RMQConnectionMetaData
implements ConnectionMetaData {
    private static final String JMS_PROVIDER_NAME = "RabbitMQ";
    private static final GenericVersion RABBITMQ_VERSION_OBJECT = new GenericVersion(Version.class.getPackage().getImplementationVersion());
    private static final String RABBITMQ_VERSION = RABBITMQ_VERSION_OBJECT.toString();
    private static final int RABBITMQ_MAJOR_VERSION = RABBITMQ_VERSION_OBJECT.getMajor();
    private static final int RABBITMQ_MINOR_VERSION = RABBITMQ_VERSION_OBJECT.getMinor();
    private static final String JMS_VERSION = "1.1";
    private static final int JMS_MAJOR_VERSION = 1;
    private static final int JMS_MINOR_VERSION = 1;
    public static final String JMSX_GROUP_ID_LABEL = "JMSXGroupID";
    public static final String JMSX_GROUP_SEQ_LABEL = "JMSXGroupSeq";

    public String getJMSVersion() throws JMSException {
        return JMS_VERSION;
    }

    public int getJMSMajorVersion() throws JMSException {
        return 1;
    }

    public int getJMSMinorVersion() throws JMSException {
        return 1;
    }

    public String getJMSProviderName() throws JMSException {
        return JMS_PROVIDER_NAME;
    }

    public String getProviderVersion() throws JMSException {
        return RABBITMQ_VERSION;
    }

    public int getProviderMajorVersion() throws JMSException {
        return RABBITMQ_MAJOR_VERSION;
    }

    public int getProviderMinorVersion() throws JMSException {
        return RABBITMQ_MINOR_VERSION;
    }

    public Enumeration<String> getJMSXPropertyNames() throws JMSException {
        return new JmsXEnumerator();
    }

    public class JmsXEnumerator
    implements Enumeration<String> {
        int idx = 0;

        @Override
        public boolean hasMoreElements() {
            return this.idx < 2;
        }

        @Override
        public String nextElement() {
            switch (this.idx++) {
                case 0: {
                    return RMQConnectionMetaData.JMSX_GROUP_ID_LABEL;
                }
                case 1: {
                    return RMQConnectionMetaData.JMSX_GROUP_SEQ_LABEL;
                }
            }
            return null;
        }
    }
}

