/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.admin;

import com.rabbitmq.jms.admin.RMQObjectFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class RMQDestination
implements Queue,
Topic,
Destination,
Referenceable,
Serializable,
TemporaryQueue,
TemporaryTopic {
    private static final long serialVersionUID = 596966152753718825L;
    private static final String RABBITMQ_AMQ_TOPIC_EXCHANGE_NAME = "amq.topic";
    private static final String RABBITMQ_AMQ_TOPIC_EXCHANGE_TYPE = "topic";
    private static final String JMS_DURABLE_TOPIC_EXCHANGE_NAME = "jms.durable.topic";
    private static final String JMS_TEMP_TOPIC_EXCHANGE_NAME = "jms.temp.topic";
    private static final String RABBITMQ_UNNAMED_EXCHANGE = "";
    private static final String RABBITMQ_AMQ_DIRECT_EXCHANGE_NAME = "amq.direct";
    private static final String RABBITMQ_AMQ_DIRECT_EXCHANGE_TYPE = "direct";
    private static final String JMS_DURABLE_QUEUE_EXCHANGE_NAME = "jms.durable.queues";
    private static final String JMS_TEMP_QUEUE_EXCHANGE_NAME = "jms.temp.queues";
    private String destinationName;
    private boolean amqp;
    private String amqpExchangeName;
    private String amqpRoutingKey;
    private String amqpQueueName;
    private boolean isQueue;
    private boolean isTemporary;
    private transient boolean isDeclared;
    private final Map<String, Object> queueDeclareArguments;

    public RMQDestination() {
        this.isDeclared = false;
        this.queueDeclareArguments = null;
    }

    public RMQDestination(String destName, boolean isQueue, boolean isTemporary) {
        this(destName, isQueue, isTemporary, null);
    }

    public RMQDestination(String destName, boolean isQueue, boolean isTemporary, Map<String, Object> queueDeclareArguments) {
        this(destName, false, RMQDestination.queueOrTopicExchangeName(isQueue, isTemporary), destName, destName, isQueue, isTemporary, queueDeclareArguments);
    }

    private static final String queueOrTopicExchangeName(boolean isQueue, boolean isTemporary) {
        if (isQueue & isTemporary) {
            return JMS_TEMP_QUEUE_EXCHANGE_NAME;
        }
        if (isQueue & !isTemporary) {
            return JMS_DURABLE_QUEUE_EXCHANGE_NAME;
        }
        if (!isQueue & isTemporary) {
            return JMS_TEMP_TOPIC_EXCHANGE_NAME;
        }
        return JMS_DURABLE_TOPIC_EXCHANGE_NAME;
    }

    private static final String queueOrTopicExchangeType(boolean isQueue) {
        if (isQueue) {
            return RABBITMQ_AMQ_DIRECT_EXCHANGE_TYPE;
        }
        return RABBITMQ_AMQ_TOPIC_EXCHANGE_TYPE;
    }

    public RMQDestination(String destName, String amqpExchangeName, String amqpRoutingKey, String amqpQueueName) {
        this(destName, true, amqpExchangeName, amqpRoutingKey, amqpQueueName, true, false, null);
    }

    private RMQDestination(String destName, boolean amqp, String exchangeName, String routingKey, String queueName, boolean isQueue, boolean isTemporary, Map<String, Object> queueDeclareArguments) {
        this.destinationName = destName;
        if (amqp && (exchangeName == null != (routingKey == null) || exchangeName == null && routingKey == null && queueName == null)) {
            throw new IllegalArgumentException(String.format("Invalid AMQP resource settings (exchangeName=[%s], routingKey=[%s], queueName=[%s]).", exchangeName, routingKey, queueName));
        }
        this.amqp = amqp;
        this.amqpExchangeName = exchangeName;
        this.amqpRoutingKey = routingKey;
        this.amqpQueueName = queueName;
        this.isQueue = isQueue;
        this.isTemporary = isTemporary;
        this.isDeclared = false;
        this.queueDeclareArguments = queueDeclareArguments;
    }

    public boolean amqpWritable() {
        return this.amqp && null != this.amqpExchangeName && null != this.amqpRoutingKey;
    }

    public boolean amqpReadable() {
        return this.amqp && null != this.amqpQueueName;
    }

    public boolean isAmqp() {
        return this.amqp;
    }

    public void setAmqp(boolean amqp) {
        if (this.isDeclared()) {
            throw new IllegalStateException();
        }
        this.amqp = amqp;
        this.isQueue = true;
        this.isTemporary = false;
    }

    public String getAmqpQueueName() {
        return this.amqpQueueName;
    }

    public void setAmqpQueueName(String amqpQueueName) {
        if (this.isDeclared()) {
            throw new IllegalStateException();
        }
        this.amqpQueueName = amqpQueueName;
    }

    public String getAmqpExchangeName() {
        return this.amqpExchangeName;
    }

    public void setAmqpExchangeName(String amqpExchangeName) {
        if (this.isDeclared()) {
            throw new IllegalStateException();
        }
        this.amqpExchangeName = amqpExchangeName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        if (this.isDeclared()) {
            throw new IllegalStateException();
        }
        this.destinationName = destinationName;
    }

    public String getAmqpRoutingKey() {
        return this.amqpRoutingKey;
    }

    public void setAmqpRoutingKey(String routingKey) {
        if (this.isDeclared()) {
            throw new IllegalStateException();
        }
        this.amqpRoutingKey = routingKey;
    }

    public String amqpExchangeType() {
        return RMQDestination.queueOrTopicExchangeType(this.isQueue);
    }

    public boolean noNeedToDeclareExchange() {
        return RABBITMQ_AMQ_TOPIC_EXCHANGE_NAME.equals(this.amqpExchangeName) || RABBITMQ_AMQ_DIRECT_EXCHANGE_NAME.equals(this.amqpExchangeName) || RABBITMQ_UNNAMED_EXCHANGE.equals(this.amqpExchangeName);
    }

    public boolean isQueue() {
        return this.isQueue;
    }

    public void setQueue(boolean isQueue) {
        if (this.isDeclared()) {
            throw new IllegalStateException();
        }
        this.isQueue = isQueue;
    }

    public String getTopicName() throws JMSException {
        return this.destinationName;
    }

    public String getQueueName() throws JMSException {
        return this.destinationName;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getCanonicalName(), RMQObjectFactory.class.getName(), null);
        RMQDestination.addStringProperty(ref, "destinationName", this.destinationName);
        RMQDestination.addBooleanProperty(ref, "amqp", this.amqp);
        RMQDestination.addBooleanProperty(ref, "isQueue", this.isQueue);
        RMQDestination.addStringProperty(ref, "amqpExchangeName", this.amqpExchangeName);
        RMQDestination.addStringProperty(ref, "amqpRoutingKey", this.amqpRoutingKey);
        RMQDestination.addStringProperty(ref, "amqpQueueName", this.amqpQueueName);
        return ref;
    }

    public Map<String, Object> getQueueDeclareArguments() {
        return this.queueDeclareArguments == null ? null : Collections.unmodifiableMap(this.queueDeclareArguments);
    }

    private static final void addStringProperty(Reference ref, String propertyName, String value) {
        if (value == null || propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, value);
        ref.add(ra);
    }

    private static final void addBooleanProperty(Reference ref, String propertyName, boolean value) {
        if (propertyName == null) {
            return;
        }
        if (value) {
            StringRefAddr ra = new StringRefAddr(propertyName, String.valueOf(value));
            ref.add(ra);
        }
    }

    public boolean isDeclared() {
        return this.isDeclared;
    }

    public void setDeclared(boolean isDeclared) {
        this.isDeclared = isDeclared;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void delete() throws JMSException {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amqp ? 1231 : 1237);
        result = 31 * result + (this.amqpExchangeName == null ? 0 : this.amqpExchangeName.hashCode());
        result = 31 * result + (this.amqpQueueName == null ? 0 : this.amqpQueueName.hashCode());
        result = 31 * result + (this.amqpRoutingKey == null ? 0 : this.amqpRoutingKey.hashCode());
        result = 31 * result + (this.destinationName == null ? 0 : this.destinationName.hashCode());
        result = 31 * result + (this.isQueue ? 1231 : 1237);
        result = 31 * result + (this.isTemporary ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RMQDestination)) {
            return false;
        }
        RMQDestination other = (RMQDestination)obj;
        if (this.amqp != other.amqp) {
            return false;
        }
        if (this.amqpExchangeName == null ? other.amqpExchangeName != null : !this.amqpExchangeName.equals(other.amqpExchangeName)) {
            return false;
        }
        if (this.amqpQueueName == null ? other.amqpQueueName != null : !this.amqpQueueName.equals(other.amqpQueueName)) {
            return false;
        }
        if (this.amqpRoutingKey == null ? other.amqpRoutingKey != null : !this.amqpRoutingKey.equals(other.amqpRoutingKey)) {
            return false;
        }
        if (this.destinationName == null ? other.destinationName != null : !this.destinationName.equals(other.destinationName)) {
            return false;
        }
        if (this.isQueue != other.isQueue) {
            return false;
        }
        return this.isTemporary == other.isTemporary;
    }

    public String toString() {
        return "RMQDestination{" + "destinationName='" + this.destinationName + (this.isQueue ? "', queue(" : "', topic(") + (this.isTemporary ? "temporary" : "permanent") + (this.amqp ? ", amqp)" : ")") + "', amqpExchangeName='" + this.amqpExchangeName + "', amqpRoutingKey='" + this.amqpRoutingKey + "', amqpQueueName='" + this.amqpQueueName + "'}";
    }
}

