/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.Visitor;
import com.rabbitmq.jms.parse.sql.SqlTokenType;
import com.rabbitmq.jms.parse.sql.SqlTreeNode;
import java.util.List;

class SqlCompilerVisitor
implements Visitor<SqlTreeNode> {
    private static final boolean BEFORE = true;
    private static final boolean AFTER = false;
    private final StringBuilder sb = new StringBuilder();

    SqlCompilerVisitor() {
    }

    public boolean visitBefore(SqlTreeNode parent, SqlTreeNode[] children) {
        SqlCompilerVisitor.codeOf(true, this.sb, parent, children);
        return true;
    }

    public boolean visitAfter(SqlTreeNode parent, SqlTreeNode[] children) {
        SqlCompilerVisitor.codeOf(false, this.sb, parent, children);
        return true;
    }

    public String extractCode() {
        if (this.sb.length() == 0) {
            return "";
        }
        return this.sb.substring(this.sb.charAt(0) == ',' ? 1 : 0);
    }

    void clearCode() {
        this.sb.setLength(0);
    }

    private static final void codeOf(boolean before, StringBuilder sb, SqlTreeNode parent, SqlTreeNode[] children) {
        block0 : switch (parent.treeType()) {
            case CONJUNCTION: {
                if (before) {
                    sb.append(",{").append((CharSequence)SqlCompilerVisitor.atomString(SqlTokenType.AND.opCode()));
                    break;
                }
                sb.append('}');
                break;
            }
            case DISJUNCTION: {
                if (before) {
                    sb.append(",{").append((CharSequence)SqlCompilerVisitor.atomString(SqlTokenType.OR.opCode()));
                    break;
                }
                sb.append('}');
                break;
            }
            case LEAF: {
                switch (parent.value().type()) {
                    case FALSE: 
                    case TRUE: {
                        if (!before) break block0;
                        sb.append(',').append((CharSequence)SqlCompilerVisitor.atomString(parent.value().type().opCode()));
                        break block0;
                    }
                    case FLOAT: {
                        if (!before) break block0;
                        sb.append(',').append(parent.value().getFloat());
                        break block0;
                    }
                    case HEX: {
                        if (!before) break block0;
                        sb.append(',').append(parent.value().getHex());
                        break block0;
                    }
                    case IDENT: {
                        if (!before) break block0;
                        sb.append(',').append((CharSequence)SqlCompilerVisitor.identString(parent.value().getIdent()));
                        break block0;
                    }
                    case INT: {
                        if (!before) break block0;
                        sb.append(',').append(parent.value().getLong());
                        break block0;
                    }
                    case LIST: {
                        if (!before) break block0;
                        sb.append(',').append((CharSequence)SqlCompilerVisitor.stringListString(parent.value().getList()));
                        break block0;
                    }
                    case STRING: {
                        if (!before) break block0;
                        sb.append(',').append((CharSequence)SqlCompilerVisitor.binString(parent.value().getString()));
                        break block0;
                    }
                    default: {
                        throw new RuntimeException(String.format("Cannot compile tree type: [%s] with token [%s].", new Object[]{parent.treeType(), parent.value()}));
                    }
                }
            }
            case LIST: {
                if (!before) break;
                sb.append(',').append((CharSequence)SqlCompilerVisitor.stringListString(parent.value().getList()));
                break;
            }
            case PATTERN1: {
                if (before) break;
                sb.append(',').append((CharSequence)SqlCompilerVisitor.atomString("no_escape"));
                break;
            }
            case PATTERN2: {
                break;
            }
            case POSTFIXUNARYOP: 
            case PREFIXUNARYOP: 
            case TERNARYOP: 
            case BINARYOP: {
                switch (parent.value().type()) {
                    case BETWEEN: 
                    case NOT: 
                    case NOT_BETWEEN: 
                    case NOT_NULL: 
                    case NULL: 
                    case OP_MINUS: 
                    case OP_PLUS: 
                    case CMP_EQ: 
                    case CMP_GT: 
                    case CMP_GTEQ: 
                    case CMP_LT: 
                    case CMP_LTEQ: 
                    case CMP_NEQ: 
                    case IN: 
                    case LIKE: 
                    case NOT_IN: 
                    case NOT_LIKE: 
                    case OP_DIV: 
                    case OP_MULT: {
                        if (before) {
                            sb.append(",{").append((CharSequence)SqlCompilerVisitor.atomString(parent.value().type().opCode()));
                            break block0;
                        }
                        sb.append('}');
                        break block0;
                    }
                }
                throw new RuntimeException(String.format("Internal error: cannot compile tree type: [%s] with token [%s].", new Object[]{parent.treeType(), parent.value()}));
            }
            default: {
                throw new RuntimeException(String.format("Internal error: cannot compile tree type: [%s].", new Object[]{parent.treeType()}));
            }
        }
    }

    private static StringBuilder atomString(String str) {
        return new StringBuilder().append('\'').append(str).append('\'');
    }

    private static <Obj> StringBuilder prepend(Obj obj, StringBuilder sb) {
        return sb.insert(0, obj);
    }

    private static StringBuilder identString(String identName) {
        return SqlCompilerVisitor.prepend(Character.valueOf('{'), SqlCompilerVisitor.atomString("ident")).append(',').append((CharSequence)SqlCompilerVisitor.binString(identName)).append('}');
    }

    private static StringBuilder stringListString(List<String> list) {
        if (list.size() == 0) {
            return new StringBuilder("[]");
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(',').append((CharSequence)SqlCompilerVisitor.binString(s));
        }
        return sb.replace(0, 1, "[").append(']');
    }

    private static StringBuilder binString(String str) {
        StringBuilder sb = new StringBuilder("<<\"");
        for (char c : str.toCharArray()) {
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.append("\">>");
    }
}

