/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

class GenericVersion {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public GenericVersion(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = GenericVersion.non_null(qualifier);
    }

    public GenericVersion(int major, int minor, int micro) {
        this(major, minor, micro, "");
    }

    public GenericVersion(int major, int minor) {
        this(major, minor, 0, "");
    }

    public GenericVersion(int major) {
        this(major, 0, 0, "");
    }

    public GenericVersion(String versionString) {
        int mode = 0;
        int[] ver = new int[]{0, 0, 0};
        StringBuilder qual = new StringBuilder();
        for (char ch : GenericVersion.non_null(versionString).toCharArray()) {
            if (mode == 3) {
                qual.append(ch);
                continue;
            }
            if (Character.isDigit(ch)) {
                ver[mode] = 10 * ver[mode] + Character.digit(ch, 10);
                continue;
            }
            if (ch == '.') {
                ++mode;
                continue;
            }
            mode = 3;
            qual.append(ch);
        }
        this.major = ver[0];
        this.minor = ver[1];
        this.micro = ver[2];
        this.qualifier = qual.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.micro + this.qualifier;
    }

    private static final String non_null(String str) {
        return str == null ? "" : str;
    }
}

