/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.admin;

import com.rabbitmq.jms.admin.RMQConnectionFactory;
import com.rabbitmq.jms.admin.RMQDestination;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQObjectFactory
implements ObjectFactory {
    private static final String ENV_CLASS_NAME = "className";
    private final Logger logger = LoggerFactory.getLogger(RMQObjectFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable<?, ?> environment) throws Exception {
        String className;
        Reference ref;
        if (obj == null) {
            return null;
        }
        Reference reference = ref = obj instanceof Reference ? (Reference)obj : null;
        if (ref == null && (environment == null || environment.isEmpty())) {
            throw new NamingException("Unable to instantiate object: obj is not a Reference instance and environment table is empty");
        }
        String string = className = ref != null ? ref.getClassName() : (String)environment.get(ENV_CLASS_NAME);
        if (className == null || className.trim().length() == 0) {
            throw new NamingException("Unable to instantiate object: type has not been specified");
        }
        boolean topic = false;
        boolean connectionFactory = false;
        if (QueueConnectionFactory.class.getName().equals(className) || TopicConnectionFactory.class.getName().equals(className) || ConnectionFactory.class.getName().equals(className) || RMQConnectionFactory.class.getName().equals(className)) {
            connectionFactory = true;
        } else if (Topic.class.getName().equals(className)) {
            topic = true;
        } else if (!Queue.class.getName().equals(className)) {
            if (RMQDestination.class.getName().equals(className)) {
                topic = !this.getBooleanProperty(ref, environment, "isQueue", true, false);
            } else {
                throw new NamingException(String.format("Unknown class [%s]", className));
            }
        }
        if (connectionFactory) {
            return this.createConnectionFactory(ref, environment, name);
        }
        return this.createDestination(ref, environment, name, topic);
    }

    public Object createConnectionFactory(Reference ref, Hashtable<?, ?> environment, Name name) throws NamingException {
        this.logger.trace("Creating connection factory ref '{}', name '{}'.", (Object)ref, (Object)name);
        RMQConnectionFactory f = new RMQConnectionFactory();
        try {
            f.setUri(this.getStringProperty(ref, environment, "uri", true, f.getUri()));
        }
        catch (JMSException e) {
            this.logger.warn("Failed to set RMQConnectionFactory properties by URI--defaults taken initially.", (Throwable)e);
        }
        f.setHost(this.getStringProperty(ref, environment, "host", true, f.getHost()));
        f.setPassword(this.getStringProperty(ref, environment, "password", true, f.getPassword()));
        f.setPort(this.getIntProperty(ref, environment, "port", true, f.getPort()));
        f.setQueueBrowserReadMax(this.getIntProperty(ref, environment, "queueBrowserReadMax", true, f.getQueueBrowserReadMax()));
        f.setOnMessageTimeoutMs(this.getIntProperty(ref, environment, "onMessageTimeoutMs", true, f.getOnMessageTimeoutMs()));
        f.setChannelsQos(this.getIntProperty(ref, environment, "channelsQos", true, f.getChannelsQos()));
        if (this.getBooleanProperty(ref, environment, "ssl", true, f.isSsl())) {
            try {
                f.useSslProtocol();
            }
            catch (NoSuchAlgorithmException e) {
                throw new NamingException("Error while enabling TLS: " + e.getMessage());
            }
        }
        f.setTerminationTimeout(this.getLongProperty(ref, environment, "terminationTimeout", true, f.getTerminationTimeout()));
        f.setUsername(this.getStringProperty(ref, environment, "username", true, f.getUsername()));
        f.setVirtualHost(this.getStringProperty(ref, environment, "virtualHost", true, f.getVirtualHost()));
        f.setCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose(this.getBooleanProperty(ref, environment, "cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose", true, f.isCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose()));
        f.setDeclareReplyToDestination(this.getBooleanProperty(ref, environment, "declareReplyToDestination", true, true));
        return f;
    }

    public Object createDestination(Reference ref, Hashtable<?, ?> environment, Name name, boolean topic) throws NamingException {
        this.logger.trace("Creating destination ref '{}', name '{}' (topic={}).", new Object[]{ref, name, topic});
        String dname = this.getStringProperty(ref, environment, "destinationName", false, null);
        boolean amqp = this.getBooleanProperty(ref, environment, "amqp", true, false);
        if (amqp) {
            String amqpExchangeName = this.getStringProperty(ref, environment, "amqpExchangeName", true, null);
            String amqpRoutingKey = this.getStringProperty(ref, environment, "amqpRoutingKey", true, null);
            String amqpQueueName = this.getStringProperty(ref, environment, "amqpQueueName", true, null);
            return new RMQDestination(dname, amqpExchangeName, amqpRoutingKey, amqpQueueName);
        }
        return new RMQDestination(dname, !topic, false);
    }

    private String getStringProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, String defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        return content;
    }

    private boolean getBooleanProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, boolean defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        return Boolean.valueOf(content);
    }

    private int getIntProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, int defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(content);
        }
        catch (Exception x) {
            NamingException nx = new NamingException(String.format("Property [%s] is present but is not an integer value [%s]", propertyName, content));
            nx.setRootCause(x);
            throw nx;
        }
    }

    private long getLongProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, long defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(content);
        }
        catch (Exception x) {
            NamingException nx = new NamingException(String.format("Property [%s] is present but is not a long integer value [%s]", propertyName, content));
            nx.setRootCause(x);
            throw nx;
        }
    }

    private static String propertyStringContent(RefAddr ra) {
        return ra == null ? null : (ra.getContent() == null ? null : ra.getContent().toString());
    }

    private static String environmentPropertyStringContent(Object propValue) {
        return propValue == null ? null : propValue.toString();
    }

    private static String propertyContent(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull) throws NamingException {
        String content;
        if (!(mayBeNull || ref != null && ref.get(propertyName) != null || environment != null && environment.get(propertyName) != null)) {
            throw new NamingException(String.format("Property [%s] may not be null.", propertyName));
        }
        String string = content = ref != null ? RMQObjectFactory.propertyStringContent(ref.get(propertyName)) : RMQObjectFactory.environmentPropertyStringContent(environment.get(propertyName));
        if (content == null && !mayBeNull) {
            throw new NamingException(String.format("Property [%s] is present but is lacking a value.", propertyName));
        }
        return content;
    }
}

