/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.rabbitmq.http.client.ClientParameters;
import com.rabbitmq.http.client.GetAckMode;
import com.rabbitmq.http.client.GetEncoding;
import com.rabbitmq.http.client.HttpLayer;
import com.rabbitmq.http.client.JdkHttpClientHttpLayer;
import com.rabbitmq.http.client.ParameterizedTypeReference;
import com.rabbitmq.http.client.Utils;
import com.rabbitmq.http.client.domain.AlivenessTestResult;
import com.rabbitmq.http.client.domain.BindingInfo;
import com.rabbitmq.http.client.domain.ChannelInfo;
import com.rabbitmq.http.client.domain.ClusterId;
import com.rabbitmq.http.client.domain.ConnectionInfo;
import com.rabbitmq.http.client.domain.ConsumerDetails;
import com.rabbitmq.http.client.domain.CurrentUserDetails;
import com.rabbitmq.http.client.domain.Definitions;
import com.rabbitmq.http.client.domain.DeleteQueueParameters;
import com.rabbitmq.http.client.domain.DetailsParameters;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import com.rabbitmq.http.client.domain.InboundMessage;
import com.rabbitmq.http.client.domain.MqttVhostPortInfo;
import com.rabbitmq.http.client.domain.NodeInfo;
import com.rabbitmq.http.client.domain.OutboundMessage;
import com.rabbitmq.http.client.domain.OverviewResponse;
import com.rabbitmq.http.client.domain.Page;
import com.rabbitmq.http.client.domain.PolicyInfo;
import com.rabbitmq.http.client.domain.QueryParameters;
import com.rabbitmq.http.client.domain.QueueInfo;
import com.rabbitmq.http.client.domain.ShovelInfo;
import com.rabbitmq.http.client.domain.ShovelStatus;
import com.rabbitmq.http.client.domain.TopicPermissions;
import com.rabbitmq.http.client.domain.UpstreamDetails;
import com.rabbitmq.http.client.domain.UpstreamInfo;
import com.rabbitmq.http.client.domain.UpstreamSetDetails;
import com.rabbitmq.http.client.domain.UpstreamSetInfo;
import com.rabbitmq.http.client.domain.UserConnectionInfo;
import com.rabbitmq.http.client.domain.UserInfo;
import com.rabbitmq.http.client.domain.UserPermissions;
import com.rabbitmq.http.client.domain.VhostInfo;
import com.rabbitmq.http.client.domain.VhostLimits;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class Client {
    private final HttpLayer httpLayer;
    protected final URI rootUri;

    public Client(URL url, String username, String password) throws MalformedURLException, URISyntaxException {
        this(new ClientParameters().url(url).username(username).password(password));
    }

    public Client(URL url, String username, String password, SSLContext sslContext) throws MalformedURLException, URISyntaxException {
        this(new ClientParameters().url(url).username(username).password(password).httpLayerFactory(JdkHttpClientHttpLayer.configure().clientBuilderConsumer(builder -> builder.sslContext(sslContext)).create()));
    }

    public Client(String url) throws MalformedURLException, URISyntaxException {
        this(new ClientParameters().url(url));
    }

    public Client(ClientParameters parameters) throws URISyntaxException, MalformedURLException {
        parameters.validate();
        URL url = parameters.getUrl();
        this.rootUri = Utils.rootUri(url);
        HttpLayer.HttpLayerFactory httpLayerFactory = parameters.getHttpLayerFactory() == null ? JdkHttpClientHttpLayer.configure().create() : parameters.getHttpLayerFactory();
        this.httpLayer = httpLayerFactory.create(parameters);
    }

    public OverviewResponse getOverview() {
        return this.httpLayer.get(this.uriWithPath("./overview"), OverviewResponse.class);
    }

    public boolean alivenessTest(String vhost) {
        URI uri = this.uri().withEncodedPath("./aliveness-test").withPath(vhost).get();
        return this.httpLayer.get(uri, AlivenessTestResult.class).isSuccessful();
    }

    public CurrentUserDetails whoAmI() {
        URI uri = this.uriWithPath("./whoami/");
        return this.httpLayer.get(uri, CurrentUserDetails.class);
    }

    public List<NodeInfo> getNodes() {
        URI uri = this.uriWithPath("./nodes/");
        return Arrays.asList(this.httpLayer.get(uri, NodeInfo[].class));
    }

    public NodeInfo getNode(String name) {
        URI uri = this.uri().withEncodedPath("./nodes").withPath(name).get();
        return this.httpLayer.get(uri, NodeInfo.class);
    }

    public List<ConnectionInfo> getConnections() {
        URI uri = this.uri().withEncodedPath("./connections/").get();
        return Arrays.asList(this.httpLayer.get(uri, ConnectionInfo[].class));
    }

    public Page<ConnectionInfo> getConnections(QueryParameters queryParameters) {
        URI uri = this.uri().withEncodedPath("./connections/").withQueryParameters(queryParameters).get();
        ParameterizedTypeReference<Page<ConnectionInfo>> type = new ParameterizedTypeReference<Page<ConnectionInfo>>(){};
        if (queryParameters.pagination().hasAny()) {
            return this.httpLayer.get(uri, type);
        }
        return new Page<Object>((Object[])this.httpLayer.get(uri, ConnectionInfo[].class));
    }

    public ConnectionInfo getConnection(String name) {
        URI uri = this.uri().withEncodedPath("./connections").withPath(name).get();
        return this.httpLayer.get(uri, ConnectionInfo.class);
    }

    public List<UserConnectionInfo> getConnectionsOfUser(String username) {
        URI uri = this.uri().withEncodedPath("./connections/username/").withPath(username).get();
        return Arrays.asList(this.httpLayer.get(uri, UserConnectionInfo[].class));
    }

    public void closeConnection(String name) {
        URI uri = this.uri().withEncodedPath("./connections").withPath(name).get();
        this.deleteIgnoring404(uri);
    }

    public void closeAllConnectionsOfUser(String username) {
        URI uri = this.uri().withEncodedPath("./connections/username/").withPath(username).get();
        this.deleteIgnoring404(uri);
    }

    public void closeConnection(String name, String reason) {
        URI uri = this.uri().withEncodedPath("./connections").withPath(name).get();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Reason", reason);
        this.deleteIgnoring404(uri, headers);
    }

    public List<ConsumerDetails> getConsumers() {
        URI uri = this.uriWithPath("./consumers/");
        return Arrays.asList(this.httpLayer.get(uri, ConsumerDetails[].class));
    }

    public List<ConsumerDetails> getConsumers(String vhost) {
        URI uri = this.uri().withEncodedPath("./consumers").withPath(vhost).get();
        return Arrays.asList(this.httpLayer.get(uri, ConsumerDetails[].class));
    }

    public List<ChannelInfo> getChannels() {
        URI uri = this.uriWithPath("./channels/");
        return Arrays.asList(this.httpLayer.get(uri, ChannelInfo[].class));
    }

    public Page<ChannelInfo> getChannels(QueryParameters queryParameters) {
        URI uri = this.uri().withEncodedPath("./channels").withQueryParameters(queryParameters).get();
        ParameterizedTypeReference<Page<ChannelInfo>> type = new ParameterizedTypeReference<Page<ChannelInfo>>(){};
        if (queryParameters.pagination().hasAny()) {
            return this.httpLayer.get(uri, type);
        }
        return new Page<Object>((Object[])this.httpLayer.get(uri, ChannelInfo[].class));
    }

    public List<ChannelInfo> getChannels(String connectionName) {
        URI uri = this.uri().withEncodedPath("./connections").withPath(connectionName).withEncodedPath("channels").get();
        return Arrays.asList(this.httpLayer.get(uri, ChannelInfo[].class));
    }

    public ChannelInfo getChannel(String name) {
        URI uri = this.uri().withEncodedPath("./channels").withPath(name).get();
        return this.httpLayer.get(uri, ChannelInfo.class);
    }

    public List<VhostInfo> getVhosts() {
        URI uri = this.uriWithPath("./vhosts/");
        return Arrays.asList(this.httpLayer.get(uri, VhostInfo[].class));
    }

    public VhostInfo getVhost(String name) {
        URI uri = this.uri().withEncodedPath("./vhosts").withPath(name).get();
        return this.getForObjectReturningNullOn404(uri, VhostInfo.class);
    }

    public void createVhost(String name, boolean tracing, String description, String ... tags) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tracing", tracing);
        if (description != null && !description.isEmpty()) {
            body.put("description", description);
        }
        if (tags != null && tags.length > 0) {
            body.put("tags", String.join((CharSequence)",", tags));
        }
        URI uri = this.uri().withEncodedPath("./vhosts").withPath(name).get();
        this.httpLayer.put(uri, body);
        this.httpLayer.put(uri, body);
    }

    public void createVhost(String name, String description, String ... tags) {
        this.createVhost(name, false, description, tags);
    }

    public void createVhost(String name, boolean tracing) {
        this.createVhost(name, tracing, null, new String[0]);
    }

    public void createVhost(String name) {
        URI uri = this.uri().withEncodedPath("./vhosts/").withPath(name).get();
        this.httpLayer.put(uri, null);
    }

    public void deleteVhost(String name) {
        URI uri = this.uri().withEncodedPath("./vhosts/").withPath(name).get();
        this.deleteIgnoring404(uri);
    }

    public List<UserPermissions> getPermissionsIn(String vhost) {
        URI uri = this.uri().withEncodedPath("./vhosts/").withPath(vhost).withEncodedPath("/permissions").get();
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<UserPermissions> getPermissionsOf(String username) {
        URI uri = this.uri().withEncodedPath("./users/").withPath(username).withEncodedPath("/permissions").get();
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<UserPermissions> getPermissions() {
        URI uri = this.uri().withEncodedPath("./permissions").get();
        UserPermissions[] result = this.getForObjectReturningNullOn404(uri, UserPermissions[].class);
        return this.asListOrNull(result);
    }

    public UserPermissions getPermissions(String vhost, String username) {
        URI uri = this.uri().withEncodedPath("./permissions").withPath(vhost).withPath(username).get();
        return this.getForObjectReturningNullOn404(uri, UserPermissions.class);
    }

    public List<TopicPermissions> getTopicPermissionsIn(String vhost) {
        URI uri = this.uri().withEncodedPath("./vhosts").withPath(vhost).withEncodedPath("topic-permissions").get();
        TopicPermissions[] result = this.getForObjectReturningNullOn404(uri, TopicPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<TopicPermissions> getTopicPermissionsOf(String username) {
        URI uri = this.uri().withEncodedPath("./users").withPath(username).withEncodedPath("topic-permissions").get();
        TopicPermissions[] result = this.getForObjectReturningNullOn404(uri, TopicPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<TopicPermissions> getTopicPermissions() {
        URI uri = this.uriWithPath("./topic-permissions");
        TopicPermissions[] result = this.getForObjectReturningNullOn404(uri, TopicPermissions[].class);
        return this.asListOrNull(result);
    }

    public List<TopicPermissions> getTopicPermissions(String vhost, String username) {
        URI uri = this.uri().withEncodedPath("./topic-permissions").withPath(vhost).withPath(username).get();
        return this.asListOrNull(this.getForObjectReturningNullOn404(uri, TopicPermissions[].class));
    }

    public List<ExchangeInfo> getExchanges() {
        URI uri = this.uriWithPath("./exchanges/");
        return Arrays.asList(this.httpLayer.get(uri, ExchangeInfo[].class));
    }

    public Page<ExchangeInfo> getExchanges(QueryParameters queryParameters) {
        URI uri = this.uri().withEncodedPath("./exchanges").withQueryParameters(queryParameters).get();
        ParameterizedTypeReference<Page<ExchangeInfo>> type = new ParameterizedTypeReference<Page<ExchangeInfo>>(){};
        if (queryParameters.pagination().hasAny()) {
            return this.httpLayer.get(uri, type);
        }
        return new Page<Object>((Object[])this.httpLayer.get(uri, ExchangeInfo[].class));
    }

    public List<ExchangeInfo> getExchanges(String vhost) {
        URI uri = this.uri().withEncodedPath("./exchanges").withPath(vhost).get();
        ExchangeInfo[] result = this.getForObjectReturningNullOn404(uri, ExchangeInfo[].class);
        return this.asListOrNull(result);
    }

    public Page<ExchangeInfo> getExchanges(String vhost, QueryParameters queryParameters) {
        URI uri = this.uri().withEncodedPath("./exchanges").withPath(vhost).withQueryParameters(queryParameters).get();
        ParameterizedTypeReference<Page<ExchangeInfo>> type = new ParameterizedTypeReference<Page<ExchangeInfo>>(){};
        if (queryParameters.pagination().hasAny()) {
            return this.httpLayer.get(uri, type);
        }
        return new Page<Object>((Object[])this.httpLayer.get(uri, ExchangeInfo[].class));
    }

    public ExchangeInfo getExchange(String vhost, String name) {
        URI uri = this.uri().withEncodedPath("./exchanges").withPath(vhost).withPath(name).get();
        return this.getForObjectReturningNullOn404(uri, ExchangeInfo.class);
    }

    public void declareExchange(String vhost, String name, ExchangeInfo info) {
        URI uri = this.uri().withEncodedPath("./exchanges").withPath(vhost).withPath(name).get();
        this.httpLayer.put(uri, info);
    }

    public void deleteExchange(String vhost, String name) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./exchanges").withPath(vhost).withPath(name).get());
    }

    public boolean publish(String vhost, String exchange, String routingKey, OutboundMessage outboundMessage) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        Map<String, Object> body = Utils.bodyForPublish(routingKey, outboundMessage);
        URI uri = this.uri().withEncodedPath("./exchanges").withPath(vhost).withPath(exchange).withEncodedPath("/publish").get();
        Map response = this.httpLayer.post(uri, body, Map.class);
        Boolean routed = (Boolean)response.get("routed");
        if (routed == null) {
            return false;
        }
        return routed;
    }

    public List<QueueInfo> getQueues() {
        return this.getQueues((DetailsParameters)null);
    }

    public List<QueueInfo> getQueues(DetailsParameters detailsParameters) {
        URI uri = this.uri().withEncodedPath("./queues").withQueryParameters(detailsParameters == null ? Collections.emptyMap() : detailsParameters.parameters()).get();
        return Arrays.asList(this.httpLayer.get(uri, QueueInfo[].class));
    }

    public List<QueueInfo> getQueues(String vhost) {
        return this.getQueues(vhost, (DetailsParameters)null);
    }

    public List<QueueInfo> getQueues(String vhost, DetailsParameters detailsParameters) {
        URI uri = this.uri().withEncodedPath("./queues").withPath(vhost).withQueryParameters(detailsParameters == null ? Collections.emptyMap() : detailsParameters.parameters()).get();
        QueueInfo[] result = this.getForObjectReturningNullOn404(uri, QueueInfo[].class);
        return this.asListOrNull(result);
    }

    public Page<QueueInfo> getQueues(String vhost, QueryParameters queryParameters) {
        URI uri = this.uri().withEncodedPath("./queues").withPath(vhost).withQueryParameters(queryParameters).get();
        ParameterizedTypeReference<Page<QueueInfo>> type = new ParameterizedTypeReference<Page<QueueInfo>>(){};
        if (queryParameters.pagination().hasAny()) {
            return this.httpLayer.get(uri, type);
        }
        return new Page<Object>((Object[])this.httpLayer.get(uri, QueueInfo[].class));
    }

    public QueueInfo getQueue(String vhost, String name, DetailsParameters detailsParameters) {
        URI uri = this.uri().withEncodedPath("./queues").withPath(vhost).withPath(name).withQueryParameters(detailsParameters == null ? Collections.emptyMap() : detailsParameters.parameters()).get();
        return this.getForObjectReturningNullOn404(uri, QueueInfo.class);
    }

    public QueueInfo getQueue(String vhost, String name) {
        return this.getQueue(vhost, name, null);
    }

    public Page<QueueInfo> getQueues(QueryParameters queryParameters) {
        URI uri = this.uri().withEncodedPath("./queues").withQueryParameters(queryParameters).get();
        ParameterizedTypeReference<Page<QueueInfo>> type = new ParameterizedTypeReference<Page<QueueInfo>>(){};
        if (queryParameters.pagination().hasAny()) {
            return this.httpLayer.get(uri, type);
        }
        return new Page<Object>((Object[])this.httpLayer.get(uri, QueueInfo[].class));
    }

    public void declarePolicy(String vhost, String name, PolicyInfo info) {
        URI uri = this.uri().withEncodedPath("./policies").withPath(vhost).withPath(name).get();
        this.httpLayer.put(uri, info);
    }

    public void declareOperatorPolicy(String vhost, String name, PolicyInfo info) {
        URI uri = this.uri().withEncodedPath("./operator-policies").withPath(vhost).withPath(name).get();
        this.httpLayer.put(uri, info);
    }

    public void declareQueue(String vhost, String name, QueueInfo info) {
        URI uri = this.uri().withEncodedPath("./queues").withPath(vhost).withPath(name).get();
        this.httpLayer.put(uri, info);
    }

    public void purgeQueue(String vhost, String name) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./queues").withPath(vhost).withPath(name).withEncodedPath("contents/").get());
    }

    public void deleteQueue(String vhost, String name) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./queues").withPath(vhost).withPath(name).get());
    }

    public void deleteQueue(String vhost, String name, DeleteQueueParameters deleteInfo) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./queues").withPath(vhost).withPath(name).withQueryParameters(deleteInfo.getAsQueryParams()).get());
    }

    public List<InboundMessage> get(String vhost, String queue, int count, GetAckMode ackMode, GetEncoding encoding, int truncate) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        Map<String, Object> body = Utils.bodyForGet(count, ackMode, encoding, truncate);
        URI uri = this.uri().withEncodedPath("./queues").withPath(vhost).withPath(queue).withEncodedPath("get").get();
        return Arrays.asList(this.httpLayer.post(uri, body, InboundMessage[].class));
    }

    public List<InboundMessage> get(String vhost, String queue, int count, GetAckMode ackMode, GetEncoding encoding) {
        return this.get(vhost, queue, count, ackMode, encoding, -1);
    }

    public InboundMessage get(String vhost, String queue) {
        List<InboundMessage> inboundMessages = this.get(vhost, queue, 1, GetAckMode.NACK_REQUEUE_TRUE, GetEncoding.AUTO, 50000);
        if (inboundMessages != null && inboundMessages.size() == 1) {
            return inboundMessages.get(0);
        }
        return null;
    }

    public void deletePolicy(String vhost, String name) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./policies").withPath(vhost).withPath(name).get());
    }

    public void deleteOperatorPolicy(String vhost, String name) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./operator-policies").withPath(vhost).withPath(name).get());
    }

    public List<UserInfo> getUsers() {
        URI uri = this.uriWithPath("./users/");
        return Arrays.asList(this.httpLayer.get(uri, UserInfo[].class));
    }

    public UserInfo getUser(String username) {
        URI uri = this.uri().withEncodedPath("./users").withPath(username).get();
        return this.getForObjectReturningNullOn404(uri, UserInfo.class);
    }

    public void createUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null or empty. If you need to create a user that will only authenticate using an x509 certificate, use createUserWithPasswordHash with a blank hash.");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password", new String(password));
        body.put("tags", String.join((CharSequence)",", tags));
        URI uri = this.uri().withEncodedPath("./users").withPath(username).get();
        this.httpLayer.put(uri, body);
    }

    public void createUserWithPasswordHash(String username, char[] passwordHash, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (passwordHash == null) {
            passwordHash = "".toCharArray();
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password_hash", String.valueOf(passwordHash));
        body.put("tags", String.join((CharSequence)",", tags));
        URI uri = this.uri().withEncodedPath("./users").withPath(username).get();
        this.httpLayer.put(uri, body);
    }

    public void updateUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        if (password != null) {
            body.put("password", new String(password));
        }
        body.put("tags", String.join((CharSequence)",", tags));
        URI uri = this.uri().withEncodedPath("./users").withPath(username).get();
        this.httpLayer.put(uri, body);
    }

    public void deleteUser(String username) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./users").withPath(username).get());
    }

    public void updatePermissions(String vhost, String username, UserPermissions permissions) {
        URI uri = this.uri().withEncodedPath("./permissions").withPath(vhost).withPath(username).get();
        this.httpLayer.put(uri, permissions);
    }

    public void clearPermissions(String vhost, String username) {
        URI uri = this.uri().withEncodedPath("./permissions").withPath(vhost).withPath(username).get();
        this.deleteIgnoring404(uri);
    }

    public void updateTopicPermissions(String vhost, String username, TopicPermissions permissions) {
        URI uri = this.uri().withEncodedPath("./topic-permissions").withPath(vhost).withPath(username).get();
        this.httpLayer.put(uri, permissions);
    }

    public void clearTopicPermissions(String vhost, String username) {
        URI uri = this.uri().withEncodedPath("./topic-permissions").withPath(vhost).withPath(username).get();
        this.deleteIgnoring404(uri);
    }

    public List<PolicyInfo> getPolicies() {
        URI uri = this.uriWithPath("./policies/");
        return Arrays.asList(this.httpLayer.get(uri, PolicyInfo[].class));
    }

    public List<PolicyInfo> getPolicies(String vhost) {
        URI uri = this.uri().withEncodedPath("./policies").withPath(vhost).get();
        PolicyInfo[] result = this.getForObjectReturningNullOn404(uri, PolicyInfo[].class);
        return this.asListOrNull(result);
    }

    public List<PolicyInfo> getOperatorPolicies() {
        URI uri = this.uriWithPath("./operator-policies/");
        return Arrays.asList(this.httpLayer.get(uri, PolicyInfo[].class));
    }

    public List<PolicyInfo> getOperatorPolicies(String vhost) {
        URI uri = this.uri().withEncodedPath("./operator-policies").withPath(vhost).get();
        PolicyInfo[] result = this.getForObjectReturningNullOn404(uri, PolicyInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getBindings() {
        URI uri = this.uriWithPath("./bindings/");
        return Arrays.asList(this.httpLayer.get(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getBindings(String vhost) {
        URI uri = this.uri().withEncodedPath("./bindings").withPath(vhost).get();
        return Arrays.asList(this.httpLayer.get(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getBindingsBySource(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        URI uri = this.uri().withEncodedPath("./exchanges").withPath(vhost).withPath(x).withEncodedPath("bindings/source").get();
        return Arrays.asList(this.httpLayer.get(uri, BindingInfo[].class));
    }

    public List<BindingInfo> getExchangeBindingsByDestination(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        URI uri = this.uri().withEncodedPath("./exchanges").withPath(vhost).withPath(x).withEncodedPath("bindings/destination").get();
        BindingInfo[] result = this.httpLayer.get(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getQueueBindings(String vhost, String queue) {
        URI uri = this.uri().withEncodedPath("./queues").withPath(vhost).withPath(queue).withEncodedPath("bindings").get();
        BindingInfo[] result = this.httpLayer.get(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getQueueBindingsBetween(String vhost, String exchange, String queue) {
        URI uri = this.uri().withEncodedPath("./bindings").withPath(vhost).withEncodedPath("e").withPath(exchange).withEncodedPath("q").withPath(queue).get();
        BindingInfo[] result = this.httpLayer.get(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public List<BindingInfo> getExchangeBindingsBetween(String vhost, String source, String destination) {
        URI uri = this.uri().withEncodedPath("./bindings").withPath(vhost).withEncodedPath("e").withPath(source).withEncodedPath("e").withPath(destination).get();
        BindingInfo[] result = this.httpLayer.get(uri, BindingInfo[].class);
        return this.asListOrNull(result);
    }

    public void bindQueue(String vhost, String queue, String exchange, String routingKey) {
        this.bindQueue(vhost, queue, exchange, routingKey, new HashMap<String, Object>());
    }

    public void bindQueue(String vhost, String queue, String exchange, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("arguments", args);
        }
        body.put("routing_key", routingKey);
        URI uri = this.uri().withEncodedPath("./bindings").withPath(vhost).withEncodedPath("e").withPath(exchange).withEncodedPath("q").withPath(queue).get();
        this.httpLayer.post(uri, body, null);
    }

    public void unbindQueue(String vhost, String queue, String exchange, String routingKey) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        this.deleteIgnoring404(this.uri().withEncodedPath("./bindings").withPath(vhost).withEncodedPath("e").withPath(exchange).withEncodedPath("q").withPath(queue).withPath(routingKey).get());
    }

    public void bindExchange(String vhost, String destination, String source, String routingKey) {
        this.bindExchange(vhost, destination, source, routingKey, new HashMap<String, Object>());
    }

    public void bindExchange(String vhost, String destination, String source, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("destination cannot be null or blank");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("arguments", args);
        }
        body.put("routing_key", routingKey);
        URI uri = this.uri().withEncodedPath("./bindings").withPath(vhost).withEncodedPath("e").withPath(source).withEncodedPath("e").withPath(destination).get();
        this.httpLayer.post(uri, body, null);
    }

    public void unbindExchange(String vhost, String destination, String source, String routingKey) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("destination cannot be null or blank");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be null or blank");
        }
        this.deleteIgnoring404(this.uri().withEncodedPath("./bindings").withPath(vhost).withEncodedPath("e").withPath(source).withEncodedPath("e").withPath(destination).withPath(routingKey).get());
    }

    public ClusterId getClusterName() {
        return this.httpLayer.get(this.uriWithPath("./cluster-name"), ClusterId.class);
    }

    public void setClusterName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        URI uri = this.uriWithPath("./cluster-name");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("name", name);
        this.httpLayer.put(uri, m);
    }

    public List<Map> getExtensions() {
        URI uri = this.uriWithPath("./extensions/");
        return Arrays.asList(this.httpLayer.get(uri, Map[].class));
    }

    public Definitions getDefinitions() {
        URI uri = this.uriWithPath("./definitions/");
        return this.httpLayer.get(uri, Definitions.class);
    }

    public void declareShovel(String vhost, ShovelInfo info) {
        Map<String, Object> props = info.getDetails().getPublishProperties();
        if (props != null && props.isEmpty()) {
            throw new IllegalArgumentException("Shovel publish properties must be a non-empty map or null");
        }
        URI uri = this.uri().withEncodedPath("./parameters/shovel").withPath(vhost).withPath(info.getName()).get();
        this.httpLayer.put(uri, info);
    }

    public List<ShovelInfo> getShovels() {
        URI uri = this.uriWithPath("./parameters/shovel/");
        return Arrays.asList(this.httpLayer.get(uri, ShovelInfo[].class));
    }

    public List<ShovelInfo> getShovels(String vhost) {
        URI uri = this.uri().withEncodedPath("./parameters/shovel").withPath(vhost).get();
        ShovelInfo[] result = this.getForObjectReturningNullOn404(uri, ShovelInfo[].class);
        return this.asListOrNull(result);
    }

    public List<ShovelStatus> getShovelsStatus() {
        URI uri = this.uriWithPath("./shovels/");
        return Arrays.asList(this.httpLayer.get(uri, ShovelStatus[].class));
    }

    public List<ShovelStatus> getShovelsStatus(String vhost) {
        URI uri = this.uri().withEncodedPath("./shovels").withPath(vhost).get();
        ShovelStatus[] result = this.getForObjectReturningNullOn404(uri, ShovelStatus[].class);
        return this.asListOrNull(result);
    }

    public void deleteShovel(String vhost, String shovelname) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./parameters/shovel").withPath(vhost).withPath(shovelname).get());
    }

    public void declareUpstream(String vhost, String name, UpstreamDetails details) {
        if (details.getUri() == null || details.getUri().isBlank()) {
            throw new IllegalArgumentException("Upstream uri must not be null or empty");
        }
        URI uri = this.uri().withEncodedPath("./parameters/federation-upstream").withPath(vhost).withPath(name).get();
        UpstreamInfo body = new UpstreamInfo();
        body.setVhost(vhost);
        body.setName(name);
        body.setValue(details);
        this.httpLayer.put(uri, body);
    }

    public void deleteUpstream(String vhost, String name) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./parameters/federation-upstream").withPath(vhost).withPath(name).get());
    }

    public List<UpstreamInfo> getUpstreams() {
        return this.getParameters("federation-upstream", new ParameterizedTypeReference<List<UpstreamInfo>>(){});
    }

    public List<UpstreamInfo> getUpstreams(String vhost) {
        return this.getParameters(vhost, "federation-upstream", new ParameterizedTypeReference<List<UpstreamInfo>>(){});
    }

    public void declareUpstreamSet(String vhost, String name, List<UpstreamSetDetails> details) {
        for (UpstreamSetDetails item : details) {
            if (item.getUpstream() != null && !item.getUpstream().isBlank()) continue;
            throw new IllegalArgumentException("Each federation upstream set item must have a non-null and not empty upstream name");
        }
        URI uri = this.uri().withEncodedPath("./parameters/federation-upstream-set").withPath(vhost).withPath(name).get();
        UpstreamSetInfo body = new UpstreamSetInfo();
        body.setVhost(vhost);
        body.setName(name);
        body.setValue(details);
        this.httpLayer.put(uri, body);
    }

    public void deleteUpstreamSet(String vhost, String name) {
        this.deleteIgnoring404(this.uri().withEncodedPath("./parameters/federation-upstream-set").withPath(vhost).withPath(name).get());
    }

    public List<UpstreamSetInfo> getUpstreamSets() {
        return this.getParameters("federation-upstream-set", new ParameterizedTypeReference<List<UpstreamSetInfo>>(){});
    }

    public List<UpstreamSetInfo> getUpstreamSets(String vhost) {
        return this.getParameters(vhost, "federation-upstream-set", new ParameterizedTypeReference<List<UpstreamSetInfo>>(){});
    }

    public List<VhostLimits> getVhostLimits() {
        URI uri = this.uriWithPath("./vhost-limits/");
        return this.asListOrNull(this.getForObjectReturningNullOn404(uri, VhostLimits[].class));
    }

    public VhostLimits getVhostLimits(String vhost) {
        URI uri = this.uri().withEncodedPath("./vhost-limits").withPath(vhost).get();
        VhostLimits limits = this.httpLayer.get(uri, VhostLimits.class);
        if (limits != null && limits.getVhost() == null) {
            limits = new VhostLimits(vhost, -1, -1);
        }
        return limits;
    }

    public void limitMaxNumberOfConnections(String vhost, int limit) {
        URI uri = this.uri().withEncodedPath("./vhost-limits").withPath(vhost).withEncodedPath("max-connections").get();
        this.httpLayer.put(uri, Collections.singletonMap("value", limit));
    }

    public void limitMaxNumberOfQueues(String vhost, int limit) {
        URI uri = this.uri().withEncodedPath("./vhost-limits").withPath(vhost).withEncodedPath("max-queues").get();
        this.httpLayer.put(uri, Collections.singletonMap("value", limit));
    }

    public void clearMaxConnectionsLimit(String vhost) {
        URI uri = this.uri().withEncodedPath("./vhost-limits").withPath(vhost).withEncodedPath("max-connections").get();
        this.deleteIgnoring404(uri);
    }

    public void clearMaxQueuesLimit(String vhost) {
        URI uri = this.uri().withEncodedPath("./vhost-limits").withPath(vhost).withEncodedPath("max-queues").get();
        this.deleteIgnoring404(uri);
    }

    public MqttVhostPortInfo getMqttPortToVhostMapping() {
        return this.getGlobalParameters("mqtt_port_to_vhost_mapping", new ParameterizedTypeReference<MqttVhostPortInfo>(){});
    }

    public void deleteMqttPortToVhostMapping() {
        this.deleteIgnoring404(this.uri().withEncodedPath("./global-parameters/mqtt_port_to_vhost_mapping").get());
    }

    public void setMqttPortToVhostMapping(Map<Integer, String> portMappings) {
        for (String vhost : portMappings.values()) {
            if (!vhost.isBlank()) continue;
            throw new IllegalArgumentException("Map with undefined vhosts provided!");
        }
        URI uri = this.uri().withEncodedPath("./global-parameters/mqtt_port_to_vhost_mapping").get();
        MqttVhostPortInfo body = new MqttVhostPortInfo();
        body.setValue(portMappings);
        this.httpLayer.put(uri, body);
    }

    private <T> List<T> getParameters(String component, ParameterizedTypeReference<List<T>> responseType) {
        URI uri = this.uri().withEncodedPath("./parameters").withEncodedPath(component).withPathSeparator().get();
        return this.httpLayer.get(uri, responseType);
    }

    private <T> List<T> getParameters(String vhost, String component, ParameterizedTypeReference<List<T>> responseType) {
        URI uri = this.uri().withEncodedPath("./parameters").withEncodedPath(component).withPath(vhost).get();
        return this.getForObjectReturningNullOn404(uri, responseType);
    }

    private <T> T getGlobalParameters(String name, ParameterizedTypeReference<T> responseType) {
        URI uri = this.uri().withEncodedPath("./global-parameters").withEncodedPath(name).withPathSeparator().get();
        return this.getForObjectReturningNullOn404(uri, responseType);
    }

    private URI uriWithPath(String path) {
        return this.rootUri.resolve(path);
    }

    private Utils.URIBuilder uri() {
        return new Utils.URIBuilder(this.rootUri);
    }

    private <T> T getForObjectReturningNullOn404(URI uri, Class<T> klass) {
        return this.httpLayer.get(uri, klass);
    }

    private <T> T getForObjectReturningNullOn404(URI uri, ParameterizedTypeReference<T> responseType) {
        return this.httpLayer.get(uri, responseType);
    }

    private void deleteIgnoring404(URI uri) {
        this.httpLayer.delete(uri, null);
    }

    private void deleteIgnoring404(URI uri, Map<String, String> headers) {
        this.httpLayer.delete(uri, headers);
    }

    private <T> List<T> asListOrNull(T[] result) {
        if (result == null) {
            return null;
        }
        return Arrays.asList(result);
    }
}

