/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.http.client.ClientCreationContext;
import com.rabbitmq.http.client.ClientParameters;
import com.rabbitmq.http.client.HttpException;
import com.rabbitmq.http.client.HttpLayer;
import com.rabbitmq.http.client.JsonUtils;
import com.rabbitmq.http.client.ParameterizedTypeReference;
import com.rabbitmq.http.client.RestTemplateConfigurator;
import com.rabbitmq.http.client.SimpleRestTemplateConfigurator;
import com.rabbitmq.http.client.Utils;
import com.rabbitmq.http.client.domain.ChannelDetails;
import com.rabbitmq.http.client.domain.CurrentUserDetails;
import com.rabbitmq.http.client.domain.UserInfo;
import com.rabbitmq.http.client.domain.VhostLimits;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

@Deprecated(since="4.0.0", forRemoval=true)
final class RestTemplateHttpLayer
implements HttpLayer {
    private final RestTemplate rt;

    private RestTemplateHttpLayer(RestTemplate rt) {
        this.rt = rt;
    }

    static ObjectMapper createDefaultObjectMapper() {
        return Jackson2ObjectMapperBuilder.json().serializationInclusion(JsonInclude.Include.NON_NULL).featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT}).deserializerByType(VhostLimits.class, JsonUtils.VHOST_LIMITS_DESERIALIZER_INSTANCE).deserializerByType(UserInfo.class, JsonUtils.USER_INFO_DESERIALIZER_INSTANCE).deserializerByType(CurrentUserDetails.class, JsonUtils.CURRENT_USER_DETAILS_DESERIALIZER_INSTANCE).deserializerByType(ChannelDetails.class, JsonUtils.CHANNEL_DETAILS_DESERIALIZER_INSTANCE).build();
    }

    private static List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList xs = new ArrayList();
        xs.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(RestTemplateHttpLayer.createDefaultObjectMapper()));
        return xs;
    }

    @Override
    public <T> T get(URI uri, Class<T> responseClass) {
        try {
            return (T)this.rt.getForObject(uri, responseClass);
        }
        catch (HttpClientErrorException ce) {
            if (ce.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw ce;
        }
    }

    @Override
    public <T> T get(URI uri, ParameterizedTypeReference<T> typeReference) {
        ResponseExtractor responseExtractor;
        RequestCallback requestCallback = this.rt.httpEntityCallback(null, typeReference.getType());
        ResponseEntity response = (ResponseEntity)this.rt.execute(uri, HttpMethod.GET, requestCallback, responseExtractor = this.rt.responseEntityExtractor(typeReference.getType()));
        if (response == null) {
            throw new IllegalStateException("Response cannot be null");
        }
        return (T)response.getBody();
    }

    @Override
    public <T> T post(URI uri, Object requestBody, Class<T> responseClass) {
        if (responseClass == null) {
            this.rt.postForLocation(uri, requestBody);
            return null;
        }
        return (T)this.rt.postForObject(uri, requestBody, responseClass);
    }

    @Override
    public void put(URI uri, Object requestBody) {
        this.rt.put(uri, requestBody);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delete(URI uri, Map<String, String> headers) {
        if (headers == null) {
            try {
                this.rt.delete(uri);
                return;
            }
            catch (HttpClientErrorException ce) {
                if (ce.getStatusCode() == HttpStatus.NOT_FOUND) return;
                throw ce;
            }
        }
        try {
            LinkedMultiValueMap h = new LinkedMultiValueMap();
            headers.entrySet().forEach(arg_0 -> RestTemplateHttpLayer.lambda$delete$0((MultiValueMap)h, arg_0));
            HttpEntity entity = new HttpEntity(null, (MultiValueMap)h);
            this.rt.exchange(uri, HttpMethod.DELETE, entity, Object.class);
            return;
        }
        catch (HttpClientErrorException ce) {
            if (ce.getStatusCode() == HttpStatus.NOT_FOUND) return;
            throw ce;
        }
    }

    private static /* synthetic */ void lambda$delete$0(MultiValueMap h, Map.Entry entry) {
        h.add((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
    }

    static class RestTemplateHttpLayerFactory
    implements HttpLayer.HttpLayerFactory {
        RestTemplateHttpLayerFactory() {
        }

        @Override
        public HttpLayer create(ClientParameters parameters) {
            URI rootUri;
            RestTemplate restTemplate = new RestTemplate();
            try {
                rootUri = Utils.rootUri(parameters.getUrl());
            }
            catch (URISyntaxException e) {
                throw new HttpException(e);
            }
            catch (MalformedURLException e) {
                throw new HttpException(e);
            }
            ClientCreationContext context = new ClientCreationContext(restTemplate, parameters, rootUri);
            restTemplate.setMessageConverters(RestTemplateHttpLayer.getMessageConverters());
            RestTemplateConfigurator restTemplateConfigurator = parameters.getRestTemplateConfigurator() == null ? new SimpleRestTemplateConfigurator() : parameters.getRestTemplateConfigurator();
            restTemplate = restTemplateConfigurator.configure(context);
            return new RestTemplateHttpLayer(restTemplate);
        }
    }
}

