/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardMetricsCollector
implements MetricsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardMetricsCollector.class);
    private final ConcurrentMap<String, ConnectionState> connectionState = new ConcurrentHashMap<String, ConnectionState>();
    private final MetricRegistry registry;
    private final Counter connections;
    private final Counter channels;
    private final Meter publishedMessages;
    private final Meter consumedMessages;
    private final Meter acknowledgedMessages;
    private final Meter rejectedMessages;

    public StandardMetricsCollector(MetricRegistry registry, String metricsPrefix) {
        this.registry = registry;
        this.connections = registry.counter(metricsPrefix + ".connections");
        this.channels = registry.counter(metricsPrefix + ".channels");
        this.publishedMessages = registry.meter(metricsPrefix + ".published");
        this.consumedMessages = registry.meter(metricsPrefix + ".consumed");
        this.acknowledgedMessages = registry.meter(metricsPrefix + ".acknowledged");
        this.rejectedMessages = registry.meter(metricsPrefix + ".rejected");
    }

    public StandardMetricsCollector() {
        this(new MetricRegistry());
    }

    public StandardMetricsCollector(MetricRegistry metricRegistry) {
        this(metricRegistry, "rabbitmq");
    }

    @Override
    public void newConnection(final Connection connection) {
        try {
            if (connection.getId() == null) {
                connection.setId(UUID.randomUUID().toString());
            }
            this.connections.inc();
            this.connectionState.put(connection.getId(), new ConnectionState(connection));
            connection.addShutdownListener(new ShutdownListener(){

                @Override
                public void shutdownCompleted(ShutdownSignalException cause) {
                    StandardMetricsCollector.this.closeConnection(connection);
                }
            });
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in newConnection: " + e.getMessage());
        }
    }

    @Override
    public void closeConnection(Connection connection) {
        try {
            ConnectionState removed = (ConnectionState)this.connectionState.remove(connection.getId());
            if (removed != null) {
                this.connections.dec();
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in closeConnection: " + e.getMessage());
        }
    }

    @Override
    public void newChannel(final Channel channel) {
        try {
            this.channels.inc();
            channel.addShutdownListener(new ShutdownListener(){

                @Override
                public void shutdownCompleted(ShutdownSignalException cause) {
                    StandardMetricsCollector.this.closeChannel(channel);
                }
            });
            this.connectionState((Connection)channel.getConnection()).channelState.put(channel.getChannelNumber(), new ChannelState(channel));
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in newChannel: " + e.getMessage());
        }
    }

    @Override
    public void closeChannel(Channel channel) {
        try {
            ChannelState removed = (ChannelState)this.connectionState((Connection)channel.getConnection()).channelState.remove(channel.getChannelNumber());
            if (removed != null) {
                this.channels.dec();
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in closeChannel: " + e.getMessage());
        }
    }

    @Override
    public void basicPublish(Channel channel) {
        try {
            this.publishedMessages.mark();
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicPublish: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicConsume(Channel channel, String consumerTag, boolean autoAck) {
        block5: {
            try {
                if (autoAck) break block5;
                ChannelState channelState = this.channelState(channel);
                channelState.lock.lock();
                try {
                    this.channelState((Channel)channel).consumersWithManualAck.add(consumerTag);
                }
                finally {
                    channelState.lock.unlock();
                }
            }
            catch (Exception e) {
                LOGGER.info("Error while computing metrics in basicConsume: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void basicCancel(Channel channel, String consumerTag) {
        try {
            ChannelState channelState = this.channelState(channel);
            channelState.lock.lock();
            try {
                this.channelState((Channel)channel).consumersWithManualAck.remove(consumerTag);
            }
            finally {
                channelState.lock.unlock();
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicCancel: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumedMessage(Channel channel, long deliveryTag, boolean autoAck) {
        block5: {
            try {
                this.consumedMessages.mark();
                if (autoAck) break block5;
                ChannelState channelState = this.channelState(channel);
                channelState.lock.lock();
                try {
                    this.channelState((Channel)channel).unackedMessageDeliveryTags.add(deliveryTag);
                }
                finally {
                    channelState.lock.unlock();
                }
            }
            catch (Exception e) {
                LOGGER.info("Error while computing metrics in consumedMessage: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumedMessage(Channel channel, long deliveryTag, String consumerTag) {
        try {
            this.consumedMessages.mark();
            ChannelState channelState = this.channelState(channel);
            channelState.lock.lock();
            try {
                if (channelState.consumersWithManualAck.contains(consumerTag)) {
                    channelState.unackedMessageDeliveryTags.add(deliveryTag);
                }
            }
            finally {
                channelState.lock.unlock();
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in consumedMessage: " + e.getMessage());
        }
    }

    @Override
    public void basicAck(Channel channel, long deliveryTag, boolean multiple) {
        try {
            this.updateChannelStateAfterAckReject(channel, deliveryTag, multiple, this.acknowledgedMessages);
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicAck: " + e.getMessage());
        }
    }

    @Override
    public void basicNack(Channel channel, long deliveryTag) {
        try {
            this.updateChannelStateAfterAckReject(channel, deliveryTag, true, this.rejectedMessages);
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicNack: " + e.getMessage());
        }
    }

    @Override
    public void basicReject(Channel channel, long deliveryTag) {
        try {
            this.updateChannelStateAfterAckReject(channel, deliveryTag, false, this.rejectedMessages);
        }
        catch (Exception e) {
            LOGGER.info("Error while computing metrics in basicReject: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChannelStateAfterAckReject(Channel channel, long deliveryTag, boolean multiple, Meter meter) {
        ChannelState channelState = this.channelState(channel);
        channelState.lock.lock();
        try {
            if (multiple) {
                Iterator<Long> iterator = channelState.unackedMessageDeliveryTags.iterator();
                while (iterator.hasNext()) {
                    long messageDeliveryTag = iterator.next();
                    if (messageDeliveryTag > deliveryTag) continue;
                    iterator.remove();
                    meter.mark();
                }
            } else {
                channelState.unackedMessageDeliveryTags.remove(deliveryTag);
                meter.mark();
            }
        }
        finally {
            channelState.lock.unlock();
        }
    }

    private ConnectionState connectionState(Connection connection) {
        return (ConnectionState)this.connectionState.get(connection.getId());
    }

    private ChannelState channelState(Channel channel) {
        return (ChannelState)this.connectionState((Connection)channel.getConnection()).channelState.get(channel.getChannelNumber());
    }

    public void cleanStaleState() {
        try {
            Iterator connectionStateIterator = this.connectionState.entrySet().iterator();
            while (connectionStateIterator.hasNext()) {
                Map.Entry connectionEntry = connectionStateIterator.next();
                Connection connection = ((ConnectionState)connectionEntry.getValue()).connection;
                if (connection.isOpen()) {
                    Iterator channelStateIterator = ((ConnectionState)connectionEntry.getValue()).channelState.entrySet().iterator();
                    while (channelStateIterator.hasNext()) {
                        Map.Entry channelStateEntry = channelStateIterator.next();
                        Channel channel = ((ChannelState)channelStateEntry.getValue()).channel;
                        if (channel.isOpen()) continue;
                        channelStateIterator.remove();
                        this.channels.dec();
                        LOGGER.info("Ripped off state of channel {} of connection {}. This is abnormal, please report.", (Object)channel.getChannelNumber(), (Object)connection.getId());
                    }
                    continue;
                }
                connectionStateIterator.remove();
                this.connections.dec();
                this.channels.dec((long)((ConnectionState)connectionEntry.getValue()).channelState.size());
                LOGGER.info("Ripped off state of connection {}. This is abnormal, please report.", (Object)connection.getId());
            }
        }
        catch (Exception e) {
            LOGGER.info("Error during periodic clean of metricsCollector: " + e.getMessage());
        }
    }

    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public Counter getConnections() {
        return this.connections;
    }

    public Counter getChannels() {
        return this.channels;
    }

    public Meter getPublishedMessages() {
        return this.publishedMessages;
    }

    public Meter getConsumedMessages() {
        return this.consumedMessages;
    }

    public Meter getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public Meter getRejectedMessages() {
        return this.rejectedMessages;
    }

    private static class ChannelState {
        final Lock lock = new ReentrantLock();
        final Set<Long> unackedMessageDeliveryTags = new HashSet<Long>();
        final Set<String> consumersWithManualAck = new HashSet<String>();
        final Channel channel;

        private ChannelState(Channel channel) {
            this.channel = channel;
        }
    }

    private static class ConnectionState {
        final ConcurrentMap<Integer, ChannelState> channelState = new ConcurrentHashMap<Integer, ChannelState>();
        final Connection connection;

        private ConnectionState(Connection connection) {
            this.connection = connection;
        }
    }
}

