/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Command;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.CommandAssembler;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AMQCommand
implements Command {
    private static final int EMPTY_CONTENT_BODY_FRAME_SIZE = 8;
    private final CommandAssembler assembler;

    public AMQCommand() {
        this(null, null, null);
    }

    public AMQCommand(com.rabbitmq.client.Method method) {
        this(method, null, null);
    }

    public AMQCommand(com.rabbitmq.client.Method method, AMQContentHeader contentHeader, byte[] body) {
        this.assembler = new CommandAssembler((Method)method, contentHeader, body);
    }

    public Method getMethod() {
        return this.assembler.getMethod();
    }

    public AMQContentHeader getContentHeader() {
        return this.assembler.getContentHeader();
    }

    public byte[] getContentBody() {
        return this.assembler.getContentBody();
    }

    public boolean handleFrame(Frame f) throws IOException {
        return this.assembler.handleFrame(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(AMQChannel channel) throws IOException {
        int channelNumber = channel.getChannelNumber();
        AMQConnection connection = channel.getConnection();
        CommandAssembler commandAssembler = this.assembler;
        synchronized (commandAssembler) {
            Method m = this.assembler.getMethod();
            connection.writeFrame(m.toFrame(channelNumber));
            if (m.hasContent()) {
                byte[] body = this.assembler.getContentBody();
                connection.writeFrame(this.assembler.getContentHeader().toFrame(channelNumber, body.length));
                int frameMax = connection.getFrameMax();
                int bodyPayloadMax = frameMax == 0 ? body.length : frameMax - 8;
                for (int offset = 0; offset < body.length; offset += bodyPayloadMax) {
                    int remaining = body.length - offset;
                    int fragmentLength = remaining < bodyPayloadMax ? remaining : bodyPayloadMax;
                    Frame frame = Frame.fromBodyFragment(channelNumber, body, offset, fragmentLength);
                    connection.writeFrame(frame);
                }
            }
        }
        connection.flush();
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean suppressBody) {
        CommandAssembler commandAssembler = this.assembler;
        synchronized (commandAssembler) {
            return "" + '{' + this.assembler.getMethod() + ", " + this.assembler.getContentHeader() + ", " + AMQCommand.contentBodyStringBuilder(this.assembler.getContentBody(), suppressBody) + '}';
        }
    }

    private static StringBuilder contentBodyStringBuilder(byte[] body, boolean suppressBody) {
        try {
            if (suppressBody) {
                return new StringBuilder().append(body.length).append(" bytes of payload");
            }
            return new StringBuilder().append('\"').append(new String(body, "UTF-8")).append('\"');
        }
        catch (Exception e) {
            return new StringBuilder().append('|').append(body.length).append('|');
        }
    }

    public static void checkPreconditions() {
        AMQCommand.checkEmptyContentBodyFrameSize();
    }

    private static void checkEmptyContentBodyFrameSize() {
        Frame f = new Frame(3, 0, new byte[0]);
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try {
            f.writeTo(new DataOutputStream(s));
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)"IOException while checking EMPTY_CONTENT_BODY_FRAME_SIZE");
        }
        int actualLength = s.toByteArray().length;
        if (8 != actualLength) {
            throw new AssertionError((Object)("Internal error: expected EMPTY_CONTENT_BODY_FRAME_SIZE(8) is not equal to computed value: " + actualLength));
        }
    }
}

