/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class SocketFrameHandler
implements FrameHandler {
    public final Socket _socket;
    public final DataInputStream _inputStream;
    public final DataOutputStream _outputStream;

    public SocketFrameHandler(Socket socket) throws IOException {
        this._socket = socket;
        this._inputStream = new DataInputStream(new BufferedInputStream(this._socket.getInputStream()));
        this._outputStream = new DataOutputStream(new BufferedOutputStream(this._socket.getOutputStream()));
    }

    public InetAddress getAddress() {
        return this._socket.getInetAddress();
    }

    public int getPort() {
        return this._socket.getPort();
    }

    public void setTimeout(int timeoutMs) throws SocketException {
        this._socket.setSoTimeout(timeoutMs);
    }

    public int getTimeout() throws SocketException {
        return this._socket.getSoTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader(int major, int minor) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(1);
            this._outputStream.write(1);
            this._outputStream.write(major);
            this._outputStream.write(minor);
            this._outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader(int major, int minor, int revision) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(0);
            this._outputStream.write(major);
            this._outputStream.write(minor);
            this._outputStream.write(revision);
            this._outputStream.flush();
        }
    }

    public void sendHeader() throws IOException {
        this.sendHeader(0, 9, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame readFrame() throws IOException {
        DataInputStream dataInputStream = this._inputStream;
        synchronized (dataInputStream) {
            return Frame.readFrom(this._inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFrame(Frame frame) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            frame.writeTo(this._outputStream);
            this._outputStream.flush();
        }
    }

    public void close() {
        try {
            this._socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

