/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.utility;

import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingCell<T> {
    private boolean _filled = false;
    private T _value;
    private static final long NANOS_IN_MILLI = 1000000L;
    private static final long INFINITY = -1L;

    public synchronized T get() throws InterruptedException {
        while (!this._filled) {
            this.wait();
        }
        return this._value;
    }

    public synchronized T get(long timeout) throws InterruptedException, TimeoutException {
        if (timeout < 0L && timeout != -1L) {
            throw new AssertionError((Object)"Timeout cannot be less than zero");
        }
        if (!this._filled && timeout != 0L) {
            this.wait(timeout == -1L ? 0L : timeout);
        }
        if (!this._filled) {
            throw new TimeoutException();
        }
        return this._value;
    }

    public synchronized T uninterruptibleGet() {
        while (true) {
            try {
                return this.get();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized T uninterruptibleGet(int timeout) throws TimeoutException {
        long now = System.nanoTime() / 1000000L;
        long runTime = now + (long)timeout;
        while (true) {
            try {
                return this.get(runTime - now);
            }
            catch (InterruptedException e) {
                if ((long)timeout == -1L || (now = System.nanoTime() / 1000000L) < runTime) continue;
                throw new TimeoutException();
            }
            break;
        }
    }

    public synchronized void set(T newValue) {
        if (this._filled) {
            throw new AssertionError((Object)"BlockingCell can only be set once");
        }
        this._value = newValue;
        this._filled = true;
        this.notify();
    }

    public synchronized boolean setIfUnset(T newValue) {
        if (this._filled) {
            return false;
        }
        this.set(newValue);
        this._filled = true;
        return true;
    }
}

