/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionParameters;
import com.rabbitmq.client.NullTrustManager;
import com.rabbitmq.client.RedirectException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.SocketFrameHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactory {
    private final ConnectionParameters _params;
    private SocketFactory _factory = SocketFactory.getDefault();
    public static final String DEFAULT_SSL_PROTOCOL = "SSLv3";

    public ConnectionFactory() {
        this._params = new ConnectionParameters();
    }

    public ConnectionFactory(ConnectionParameters params) {
        this._params = params;
    }

    public ConnectionParameters getParameters() {
        return this._params;
    }

    public SocketFactory getSocketFactory() {
        return this._factory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this._factory = factory;
    }

    public void useSslProtocol() throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(DEFAULT_SSL_PROTOCOL);
    }

    public void useSslProtocol(String protocol) throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(protocol, new NullTrustManager());
    }

    public void useSslProtocol(String protocol, TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext c = SSLContext.getInstance(protocol);
        c.init(null, new TrustManager[]{trustManager}, null);
        this.useSslProtocol(c);
    }

    public void useSslProtocol(SSLContext context) {
        this.setSocketFactory(context.getSocketFactory());
    }

    protected FrameHandler createFrameHandler(Address addr) throws IOException {
        String hostName = addr.getHost();
        int portNumber = addr.getPort();
        if (portNumber == -1) {
            portNumber = 5672;
        }
        Socket socket = this._factory.createSocket();
        this.configureSocket(socket);
        socket.connect(new InetSocketAddress(hostName, portNumber));
        return new SocketFrameHandler(socket);
    }

    protected void configureSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(true);
    }

    private Connection newConnection(Address[] addrs, int maxRedirects, Map<Address, Integer> redirectAttempts) throws IOException {
        IOException lastException = null;
        for (Address addr : addrs) {
            Address[] lastKnownAddresses = new Address[]{};
            try {
                while (true) {
                    FrameHandler frameHandler = this.createFrameHandler(addr);
                    Integer redirectCount = redirectAttempts.get(addr);
                    if (redirectCount == null) {
                        redirectCount = 0;
                    }
                    boolean allowRedirects = redirectCount < maxRedirects;
                    try {
                        AMQConnection conn = new AMQConnection(this._params, frameHandler);
                        conn.start(!allowRedirects);
                        return conn;
                    }
                    catch (RedirectException e) {
                        if (!allowRedirects) {
                            throw new IOException("server ignored 'insist'");
                        }
                        redirectAttempts.put(addr, redirectCount + 1);
                        lastKnownAddresses = e.getKnownAddresses();
                        addr = e.getAddress();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                lastException = e;
                if (lastKnownAddresses.length <= 0) continue;
                try {
                    return this.newConnection(lastKnownAddresses, maxRedirects, redirectAttempts);
                }
                catch (IOException e1) {
                    lastException = e1;
                }
            }
        }
        if (lastException == null) {
            throw new IOException("failed to connect");
        }
        throw lastException;
    }

    public Connection newConnection(Address[] addrs, int maxRedirects) throws IOException {
        return this.newConnection(addrs, maxRedirects, new HashMap<Address, Integer>());
    }

    public Connection newConnection(Address[] addrs) throws IOException {
        return this.newConnection(addrs, 0);
    }

    public Connection newConnection(String hostName, int portNumber) throws IOException {
        return this.newConnection(new Address[]{new Address(hostName, portNumber)});
    }

    public Connection newConnection(String hostName) throws IOException {
        return this.newConnection(hostName, -1);
    }
}

