/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.Method;
import com.rabbitmq.client.impl.AMQBasicProperties;
import com.rabbitmq.client.impl.AMQFileProperties;
import com.rabbitmq.client.impl.AMQStreamProperties;
import com.rabbitmq.client.impl.AMQTestProperties;
import com.rabbitmq.client.impl.AMQTunnelProperties;
import com.rabbitmq.client.impl.ContentHeaderPropertyReader;
import com.rabbitmq.client.impl.ContentHeaderPropertyWriter;
import com.rabbitmq.client.impl.LongString;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public interface AMQP {
    public static final int FRAME_METHOD = 1;
    public static final int FRAME_HEADER = 2;
    public static final int FRAME_BODY = 3;
    public static final int FRAME_OOB_METHOD = 4;
    public static final int FRAME_OOB_HEADER = 5;
    public static final int FRAME_OOB_BODY = 6;
    public static final int FRAME_TRACE = 7;
    public static final int FRAME_HEARTBEAT = 8;
    public static final int FRAME_MIN_SIZE = 4096;
    public static final int FRAME_END = 206;
    public static final int REPLY_SUCCESS = 200;
    public static final int NOT_DELIVERED = 310;
    public static final int CONTENT_TOO_LARGE = 311;
    public static final int NO_ROUTE = 312;
    public static final int NO_CONSUMERS = 313;
    public static final int ACCESS_REFUSED = 403;
    public static final int NOT_FOUND = 404;
    public static final int RESOURCE_LOCKED = 405;
    public static final int PRECONDITION_FAILED = 406;
    public static final int CONNECTION_FORCED = 320;
    public static final int INVALID_PATH = 402;
    public static final int FRAME_ERROR = 501;
    public static final int SYNTAX_ERROR = 502;
    public static final int COMMAND_INVALID = 503;
    public static final int CHANNEL_ERROR = 504;
    public static final int RESOURCE_ERROR = 506;
    public static final int NOT_ALLOWED = 530;
    public static final int NOT_IMPLEMENTED = 540;
    public static final int INTERNAL_ERROR = 541;

    public static class TestProperties
    extends AMQTestProperties {
        public int getClassId() {
            return 120;
        }

        public String getClassName() {
            return "test";
        }

        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            reader.finishPresence();
        }

        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.finishPresence();
        }

        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TunnelProperties
    extends AMQTunnelProperties {
        private Map<String, Object> headers;
        private String proxyName;
        private String dataName;
        private Integer durable;
        private Integer broadcast;

        public TunnelProperties(Map<String, Object> headers, String proxyName, String dataName, Integer durable, Integer broadcast) {
            this.headers = headers;
            this.proxyName = proxyName;
            this.dataName = dataName;
            this.durable = durable;
            this.broadcast = broadcast;
        }

        public TunnelProperties() {
        }

        @Override
        public int getClassId() {
            return 110;
        }

        @Override
        public String getClassName() {
            return "tunnel";
        }

        @Override
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        @Override
        public String getProxyName() {
            return this.proxyName;
        }

        @Override
        public void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        @Override
        public String getDataName() {
            return this.dataName;
        }

        @Override
        public void setDataName(String dataName) {
            this.dataName = dataName;
        }

        @Override
        public Integer getDurable() {
            return this.durable;
        }

        @Override
        public void setDurable(Integer durable) {
            this.durable = durable;
        }

        @Override
        public Integer getBroadcast() {
            return this.broadcast;
        }

        @Override
        public void setBroadcast(Integer broadcast) {
            this.broadcast = broadcast;
        }

        @Override
        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            boolean headers_present = reader.readPresence();
            boolean proxyName_present = reader.readPresence();
            boolean dataName_present = reader.readPresence();
            boolean durable_present = reader.readPresence();
            boolean broadcast_present = reader.readPresence();
            reader.finishPresence();
            this.headers = headers_present ? reader.readTable() : null;
            this.proxyName = proxyName_present ? reader.readShortstr() : null;
            this.dataName = dataName_present ? reader.readShortstr() : null;
            this.durable = durable_present ? reader.readOctet() : null;
            this.broadcast = broadcast_present ? reader.readOctet() : null;
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writePresence(this.headers != null);
            writer.writePresence(this.proxyName != null);
            writer.writePresence(this.dataName != null);
            writer.writePresence(this.durable != null);
            writer.writePresence(this.broadcast != null);
            writer.finishPresence();
            if (this.headers != null) {
                writer.writeTable(this.headers);
            }
            if (this.proxyName != null) {
                writer.writeShortstr(this.proxyName);
            }
            if (this.dataName != null) {
                writer.writeShortstr(this.dataName);
            }
            if (this.durable != null) {
                writer.writeOctet(this.durable);
            }
            if (this.broadcast != null) {
                writer.writeOctet(this.broadcast);
            }
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append("headers=");
            acc.append(this.headers);
            acc.append(", ");
            acc.append("proxy-name=");
            acc.append(this.proxyName);
            acc.append(", ");
            acc.append("data-name=");
            acc.append(this.dataName);
            acc.append(", ");
            acc.append("durable=");
            acc.append(this.durable);
            acc.append(", ");
            acc.append("broadcast=");
            acc.append(this.broadcast);
            acc.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StreamProperties
    extends AMQStreamProperties {
        private String contentType;
        private String contentEncoding;
        private Map<String, Object> headers;
        private Integer priority;
        private Date timestamp;

        public StreamProperties(String contentType, String contentEncoding, Map<String, Object> headers, Integer priority, Date timestamp) {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.headers = headers;
            this.priority = priority;
            this.timestamp = timestamp;
        }

        public StreamProperties() {
        }

        @Override
        public int getClassId() {
            return 80;
        }

        @Override
        public String getClassName() {
            return "stream";
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @Override
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        @Override
        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            boolean contentType_present = reader.readPresence();
            boolean contentEncoding_present = reader.readPresence();
            boolean headers_present = reader.readPresence();
            boolean priority_present = reader.readPresence();
            boolean timestamp_present = reader.readPresence();
            reader.finishPresence();
            this.contentType = contentType_present ? reader.readShortstr() : null;
            this.contentEncoding = contentEncoding_present ? reader.readShortstr() : null;
            this.headers = headers_present ? reader.readTable() : null;
            this.priority = priority_present ? reader.readOctet() : null;
            this.timestamp = timestamp_present ? reader.readTimestamp() : null;
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writePresence(this.contentType != null);
            writer.writePresence(this.contentEncoding != null);
            writer.writePresence(this.headers != null);
            writer.writePresence(this.priority != null);
            writer.writePresence(this.timestamp != null);
            writer.finishPresence();
            if (this.contentType != null) {
                writer.writeShortstr(this.contentType);
            }
            if (this.contentEncoding != null) {
                writer.writeShortstr(this.contentEncoding);
            }
            if (this.headers != null) {
                writer.writeTable(this.headers);
            }
            if (this.priority != null) {
                writer.writeOctet(this.priority);
            }
            if (this.timestamp != null) {
                writer.writeTimestamp(this.timestamp);
            }
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append("content-type=");
            acc.append(this.contentType);
            acc.append(", ");
            acc.append("content-encoding=");
            acc.append(this.contentEncoding);
            acc.append(", ");
            acc.append("headers=");
            acc.append(this.headers);
            acc.append(", ");
            acc.append("priority=");
            acc.append(this.priority);
            acc.append(", ");
            acc.append("timestamp=");
            acc.append(this.timestamp);
            acc.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileProperties
    extends AMQFileProperties {
        private String contentType;
        private String contentEncoding;
        private Map<String, Object> headers;
        private Integer priority;
        private String replyTo;
        private String messageId;
        private String filename;
        private Date timestamp;
        private String clusterId;

        public FileProperties(String contentType, String contentEncoding, Map<String, Object> headers, Integer priority, String replyTo, String messageId, String filename, Date timestamp, String clusterId) {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.headers = headers;
            this.priority = priority;
            this.replyTo = replyTo;
            this.messageId = messageId;
            this.filename = filename;
            this.timestamp = timestamp;
            this.clusterId = clusterId;
        }

        public FileProperties() {
        }

        @Override
        public int getClassId() {
            return 70;
        }

        @Override
        public String getClassName() {
            return "file";
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @Override
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        @Override
        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public String getReplyTo() {
            return this.replyTo;
        }

        @Override
        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public String getClusterId() {
            return this.clusterId;
        }

        @Override
        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            boolean contentType_present = reader.readPresence();
            boolean contentEncoding_present = reader.readPresence();
            boolean headers_present = reader.readPresence();
            boolean priority_present = reader.readPresence();
            boolean replyTo_present = reader.readPresence();
            boolean messageId_present = reader.readPresence();
            boolean filename_present = reader.readPresence();
            boolean timestamp_present = reader.readPresence();
            boolean clusterId_present = reader.readPresence();
            reader.finishPresence();
            this.contentType = contentType_present ? reader.readShortstr() : null;
            this.contentEncoding = contentEncoding_present ? reader.readShortstr() : null;
            this.headers = headers_present ? reader.readTable() : null;
            this.priority = priority_present ? reader.readOctet() : null;
            this.replyTo = replyTo_present ? reader.readShortstr() : null;
            this.messageId = messageId_present ? reader.readShortstr() : null;
            this.filename = filename_present ? reader.readShortstr() : null;
            this.timestamp = timestamp_present ? reader.readTimestamp() : null;
            this.clusterId = clusterId_present ? reader.readShortstr() : null;
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writePresence(this.contentType != null);
            writer.writePresence(this.contentEncoding != null);
            writer.writePresence(this.headers != null);
            writer.writePresence(this.priority != null);
            writer.writePresence(this.replyTo != null);
            writer.writePresence(this.messageId != null);
            writer.writePresence(this.filename != null);
            writer.writePresence(this.timestamp != null);
            writer.writePresence(this.clusterId != null);
            writer.finishPresence();
            if (this.contentType != null) {
                writer.writeShortstr(this.contentType);
            }
            if (this.contentEncoding != null) {
                writer.writeShortstr(this.contentEncoding);
            }
            if (this.headers != null) {
                writer.writeTable(this.headers);
            }
            if (this.priority != null) {
                writer.writeOctet(this.priority);
            }
            if (this.replyTo != null) {
                writer.writeShortstr(this.replyTo);
            }
            if (this.messageId != null) {
                writer.writeShortstr(this.messageId);
            }
            if (this.filename != null) {
                writer.writeShortstr(this.filename);
            }
            if (this.timestamp != null) {
                writer.writeTimestamp(this.timestamp);
            }
            if (this.clusterId != null) {
                writer.writeShortstr(this.clusterId);
            }
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append("content-type=");
            acc.append(this.contentType);
            acc.append(", ");
            acc.append("content-encoding=");
            acc.append(this.contentEncoding);
            acc.append(", ");
            acc.append("headers=");
            acc.append(this.headers);
            acc.append(", ");
            acc.append("priority=");
            acc.append(this.priority);
            acc.append(", ");
            acc.append("reply-to=");
            acc.append(this.replyTo);
            acc.append(", ");
            acc.append("message-id=");
            acc.append(this.messageId);
            acc.append(", ");
            acc.append("filename=");
            acc.append(this.filename);
            acc.append(", ");
            acc.append("timestamp=");
            acc.append(this.timestamp);
            acc.append(", ");
            acc.append("cluster-id=");
            acc.append(this.clusterId);
            acc.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicProperties
    extends AMQBasicProperties {
        private String contentType;
        private String contentEncoding;
        private Map<String, Object> headers;
        private Integer deliveryMode;
        private Integer priority;
        private String correlationId;
        private String replyTo;
        private String expiration;
        private String messageId;
        private Date timestamp;
        private String type;
        private String userId;
        private String appId;
        private String clusterId;

        public BasicProperties(String contentType, String contentEncoding, Map<String, Object> headers, Integer deliveryMode, Integer priority, String correlationId, String replyTo, String expiration, String messageId, Date timestamp, String type, String userId, String appId, String clusterId) {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.headers = headers;
            this.deliveryMode = deliveryMode;
            this.priority = priority;
            this.correlationId = correlationId;
            this.replyTo = replyTo;
            this.expiration = expiration;
            this.messageId = messageId;
            this.timestamp = timestamp;
            this.type = type;
            this.userId = userId;
            this.appId = appId;
            this.clusterId = clusterId;
        }

        public BasicProperties() {
        }

        @Override
        public int getClassId() {
            return 60;
        }

        @Override
        public String getClassName() {
            return "basic";
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @Override
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        @Override
        public Integer getDeliveryMode() {
            return this.deliveryMode;
        }

        @Override
        public void setDeliveryMode(Integer deliveryMode) {
            this.deliveryMode = deliveryMode;
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        @Override
        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public String getCorrelationId() {
            return this.correlationId;
        }

        @Override
        public void setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
        }

        @Override
        public String getReplyTo() {
            return this.replyTo;
        }

        @Override
        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        @Override
        public String getExpiration() {
            return this.expiration;
        }

        @Override
        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public String getAppId() {
            return this.appId;
        }

        @Override
        public void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public String getClusterId() {
            return this.clusterId;
        }

        @Override
        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            boolean contentType_present = reader.readPresence();
            boolean contentEncoding_present = reader.readPresence();
            boolean headers_present = reader.readPresence();
            boolean deliveryMode_present = reader.readPresence();
            boolean priority_present = reader.readPresence();
            boolean correlationId_present = reader.readPresence();
            boolean replyTo_present = reader.readPresence();
            boolean expiration_present = reader.readPresence();
            boolean messageId_present = reader.readPresence();
            boolean timestamp_present = reader.readPresence();
            boolean type_present = reader.readPresence();
            boolean userId_present = reader.readPresence();
            boolean appId_present = reader.readPresence();
            boolean clusterId_present = reader.readPresence();
            reader.finishPresence();
            this.contentType = contentType_present ? reader.readShortstr() : null;
            this.contentEncoding = contentEncoding_present ? reader.readShortstr() : null;
            this.headers = headers_present ? reader.readTable() : null;
            this.deliveryMode = deliveryMode_present ? reader.readOctet() : null;
            this.priority = priority_present ? reader.readOctet() : null;
            this.correlationId = correlationId_present ? reader.readShortstr() : null;
            this.replyTo = replyTo_present ? reader.readShortstr() : null;
            this.expiration = expiration_present ? reader.readShortstr() : null;
            this.messageId = messageId_present ? reader.readShortstr() : null;
            this.timestamp = timestamp_present ? reader.readTimestamp() : null;
            this.type = type_present ? reader.readShortstr() : null;
            this.userId = userId_present ? reader.readShortstr() : null;
            this.appId = appId_present ? reader.readShortstr() : null;
            this.clusterId = clusterId_present ? reader.readShortstr() : null;
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writePresence(this.contentType != null);
            writer.writePresence(this.contentEncoding != null);
            writer.writePresence(this.headers != null);
            writer.writePresence(this.deliveryMode != null);
            writer.writePresence(this.priority != null);
            writer.writePresence(this.correlationId != null);
            writer.writePresence(this.replyTo != null);
            writer.writePresence(this.expiration != null);
            writer.writePresence(this.messageId != null);
            writer.writePresence(this.timestamp != null);
            writer.writePresence(this.type != null);
            writer.writePresence(this.userId != null);
            writer.writePresence(this.appId != null);
            writer.writePresence(this.clusterId != null);
            writer.finishPresence();
            if (this.contentType != null) {
                writer.writeShortstr(this.contentType);
            }
            if (this.contentEncoding != null) {
                writer.writeShortstr(this.contentEncoding);
            }
            if (this.headers != null) {
                writer.writeTable(this.headers);
            }
            if (this.deliveryMode != null) {
                writer.writeOctet(this.deliveryMode);
            }
            if (this.priority != null) {
                writer.writeOctet(this.priority);
            }
            if (this.correlationId != null) {
                writer.writeShortstr(this.correlationId);
            }
            if (this.replyTo != null) {
                writer.writeShortstr(this.replyTo);
            }
            if (this.expiration != null) {
                writer.writeShortstr(this.expiration);
            }
            if (this.messageId != null) {
                writer.writeShortstr(this.messageId);
            }
            if (this.timestamp != null) {
                writer.writeTimestamp(this.timestamp);
            }
            if (this.type != null) {
                writer.writeShortstr(this.type);
            }
            if (this.userId != null) {
                writer.writeShortstr(this.userId);
            }
            if (this.appId != null) {
                writer.writeShortstr(this.appId);
            }
            if (this.clusterId != null) {
                writer.writeShortstr(this.clusterId);
            }
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append("content-type=");
            acc.append(this.contentType);
            acc.append(", ");
            acc.append("content-encoding=");
            acc.append(this.contentEncoding);
            acc.append(", ");
            acc.append("headers=");
            acc.append(this.headers);
            acc.append(", ");
            acc.append("delivery-mode=");
            acc.append(this.deliveryMode);
            acc.append(", ");
            acc.append("priority=");
            acc.append(this.priority);
            acc.append(", ");
            acc.append("correlation-id=");
            acc.append(this.correlationId);
            acc.append(", ");
            acc.append("reply-to=");
            acc.append(this.replyTo);
            acc.append(", ");
            acc.append("expiration=");
            acc.append(this.expiration);
            acc.append(", ");
            acc.append("message-id=");
            acc.append(this.messageId);
            acc.append(", ");
            acc.append("timestamp=");
            acc.append(this.timestamp);
            acc.append(", ");
            acc.append("type=");
            acc.append(this.type);
            acc.append(", ");
            acc.append("user-id=");
            acc.append(this.userId);
            acc.append(", ");
            acc.append("app-id=");
            acc.append(this.appId);
            acc.append(", ");
            acc.append("cluster-id=");
            acc.append(this.clusterId);
            acc.append(")");
        }
    }

    public static class Test {

        public static interface ContentOk
        extends Method {
            public int getContentChecksum();
        }

        public static interface Content
        extends Method {
        }

        public static interface TableOk
        extends Method {
            public long getIntegerResult();

            public LongString getStringResult();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Table
        extends Method {
            public Map<java.lang.String, Object> getTable();

            public int getIntegerOp();

            public int getStringOp();
        }

        public static interface StringOk
        extends Method {
            public LongString getResult();
        }

        public static interface String
        extends Method {
            public java.lang.String getString1();

            public LongString getString2();

            public int getOperation();
        }

        public static interface IntegerOk
        extends Method {
            public long getResult();
        }

        public static interface Integer
        extends Method {
            public int getInteger1();

            public int getInteger2();

            public int getInteger3();

            public long getInteger4();

            public int getOperation();
        }
    }

    public static class Tunnel {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Request
        extends Method {
            public Map<String, Object> getMetaData();
        }
    }

    public static class Dtx {

        public static interface StartOk
        extends Method {
        }

        public static interface Start
        extends Method {
            public String getDtxIdentifier();
        }

        public static interface SelectOk
        extends Method {
        }

        public static interface Select
        extends Method {
        }
    }

    public static class Tx {

        public static interface RollbackOk
        extends Method {
        }

        public static interface Rollback
        extends Method {
        }

        public static interface CommitOk
        extends Method {
        }

        public static interface Commit
        extends Method {
        }

        public static interface SelectOk
        extends Method {
        }

        public static interface Select
        extends Method {
        }
    }

    public static class Stream {

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public String getExchange();

            public String getQueue();
        }

        public static interface Return
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public String getExchange();

            public String getRoutingKey();
        }

        public static interface Publish
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getRoutingKey();

            public boolean getMandatory();

            public boolean getImmediate();
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Consume
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getConsumerTag();

            public boolean getNoLocal();

            public boolean getExclusive();

            public boolean getNowait();
        }

        public static interface QosOk
        extends Method {
        }

        public static interface Qos
        extends Method {
            public int getPrefetchSize();

            public int getPrefetchCount();

            public int getConsumeRate();

            public boolean getGlobal();
        }
    }

    public static class File {

        public static interface Reject
        extends Method {
            public long getDeliveryTag();

            public boolean getRequeue();
        }

        public static interface Ack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();
        }

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();

            public String getIdentifier();
        }

        public static interface Return
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public String getExchange();

            public String getRoutingKey();
        }

        public static interface Publish
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getRoutingKey();

            public boolean getMandatory();

            public boolean getImmediate();

            public String getIdentifier();
        }

        public static interface Stage
        extends Method {
        }

        public static interface OpenOk
        extends Method {
            public long getStagedSize();
        }

        public static interface Open
        extends Method {
            public String getIdentifier();

            public long getContentSize();
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Consume
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getConsumerTag();

            public boolean getNoLocal();

            public boolean getNoAck();

            public boolean getExclusive();

            public boolean getNowait();
        }

        public static interface QosOk
        extends Method {
        }

        public static interface Qos
        extends Method {
            public int getPrefetchSize();

            public int getPrefetchCount();

            public boolean getGlobal();
        }
    }

    public static class Basic {

        public static interface Recover
        extends Method {
            public boolean getRequeue();
        }

        public static interface Reject
        extends Method {
            public long getDeliveryTag();

            public boolean getRequeue();
        }

        public static interface Ack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();
        }

        public static interface GetEmpty
        extends Method {
            public String getClusterId();
        }

        public static interface GetOk
        extends Method {
            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();

            public int getMessageCount();
        }

        public static interface Get
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getNoAck();
        }

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();
        }

        public static interface Return
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public String getExchange();

            public String getRoutingKey();
        }

        public static interface Publish
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getRoutingKey();

            public boolean getMandatory();

            public boolean getImmediate();
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Consume
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getConsumerTag();

            public boolean getNoLocal();

            public boolean getNoAck();

            public boolean getExclusive();

            public boolean getNowait();
        }

        public static interface QosOk
        extends Method {
        }

        public static interface Qos
        extends Method {
            public int getPrefetchSize();

            public int getPrefetchCount();

            public boolean getGlobal();
        }
    }

    public static class Queue {

        public static interface UnbindOk
        extends Method {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Unbind
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getExchange();

            public String getRoutingKey();

            public Map<String, Object> getArguments();
        }

        public static interface DeleteOk
        extends Method {
            public int getMessageCount();
        }

        public static interface Delete
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getIfUnused();

            public boolean getIfEmpty();

            public boolean getNowait();
        }

        public static interface PurgeOk
        extends Method {
            public int getMessageCount();
        }

        public static interface Purge
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getNowait();
        }

        public static interface BindOk
        extends Method {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Bind
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getExchange();

            public String getRoutingKey();

            public boolean getNowait();

            public Map<String, Object> getArguments();
        }

        public static interface DeclareOk
        extends Method {
            public String getQueue();

            public int getMessageCount();

            public int getConsumerCount();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Declare
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getPassive();

            public boolean getDurable();

            public boolean getExclusive();

            public boolean getAutoDelete();

            public boolean getNowait();

            public Map<String, Object> getArguments();
        }
    }

    public static class Exchange {

        public static interface DeleteOk
        extends Method {
        }

        public static interface Delete
        extends Method {
            public int getTicket();

            public String getExchange();

            public boolean getIfUnused();

            public boolean getNowait();
        }

        public static interface DeclareOk
        extends Method {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Declare
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getType();

            public boolean getPassive();

            public boolean getDurable();

            public boolean getAutoDelete();

            public boolean getInternal();

            public boolean getNowait();

            public Map<String, Object> getArguments();
        }
    }

    public static class Access {

        public static interface RequestOk
        extends Method {
            public int getTicket();
        }

        public static interface Request
        extends Method {
            public String getRealm();

            public boolean getExclusive();

            public boolean getPassive();

            public boolean getActive();

            public boolean getWrite();

            public boolean getRead();
        }
    }

    public static class Channel {

        public static interface CloseOk
        extends Method {
        }

        public static interface Close
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public int getClassId();

            public int getMethodId();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Alert
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public Map<String, Object> getDetails();
        }

        public static interface FlowOk
        extends Method {
            public boolean getActive();
        }

        public static interface Flow
        extends Method {
            public boolean getActive();
        }

        public static interface OpenOk
        extends Method {
        }

        public static interface Open
        extends Method {
            public String getOutOfBand();
        }
    }

    public static class Connection {

        public static interface CloseOk
        extends Method {
        }

        public static interface Close
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public int getClassId();

            public int getMethodId();
        }

        public static interface Redirect
        extends Method {
            public String getHost();

            public String getKnownHosts();
        }

        public static interface OpenOk
        extends Method {
            public String getKnownHosts();
        }

        public static interface Open
        extends Method {
            public String getVirtualHost();

            public String getCapabilities();

            public boolean getInsist();
        }

        public static interface TuneOk
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();
        }

        public static interface Tune
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();
        }

        public static interface SecureOk
        extends Method {
            public LongString getResponse();
        }

        public static interface Secure
        extends Method {
            public LongString getChallenge();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface StartOk
        extends Method {
            public Map<String, Object> getClientProperties();

            public String getMechanism();

            public LongString getResponse();

            public String getLocale();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Start
        extends Method {
            public int getVersionMajor();

            public int getVersionMinor();

            public Map<String, Object> getServerProperties();

            public LongString getMechanisms();

            public LongString getLocales();
        }
    }

    public static class PROTOCOL {
        public static final int MAJOR = 8;
        public static final int MINOR = 0;
        public static final int PORT = 5672;
    }
}

