/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.LongString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueWriter {
    private final DataOutputStream out;

    public ValueWriter(DataOutputStream out) {
        this.out = out;
    }

    public final void writeShortstr(String str) throws IOException {
        byte[] bytes = str.getBytes("utf-8");
        this.out.writeByte(bytes.length);
        this.out.write(bytes);
    }

    public final void writeLongstr(LongString str) throws IOException {
        this.writeLong((int)str.length());
        IOUtils.copy((InputStream)str.getStream(), (OutputStream)this.out);
    }

    public final void writeLongstr(String str) throws IOException {
        byte[] bytes = str.getBytes("utf-8");
        this.writeLong(bytes.length);
        this.out.write(bytes);
    }

    public final void writeShort(int s) throws IOException {
        this.out.writeShort(s);
    }

    public final void writeLong(int l) throws IOException {
        this.out.writeInt(l);
    }

    public final void writeLonglong(long ll) throws IOException {
        this.out.writeLong(ll);
    }

    public final void writeTable(Map<String, Object> table) throws IOException {
        if (table == null) {
            this.out.writeInt(0);
        } else {
            this.out.writeInt((int)Frame.tableSize(table));
            for (Map.Entry<String, Object> entry : table.entrySet()) {
                this.writeShortstr(entry.getKey());
                Object value = entry.getValue();
                if (value instanceof String) {
                    this.writeOctet(83);
                    this.writeLongstr((String)value);
                    continue;
                }
                if (value instanceof LongString) {
                    this.writeOctet(83);
                    this.writeLongstr((LongString)value);
                    continue;
                }
                if (value instanceof Integer) {
                    this.writeOctet(73);
                    this.writeLong((Integer)value);
                    continue;
                }
                if (value instanceof BigDecimal) {
                    this.writeOctet(68);
                    BigDecimal decimal = (BigDecimal)value;
                    this.writeOctet(decimal.scale());
                    BigInteger unscaled = decimal.unscaledValue();
                    if (unscaled.bitLength() > 32) {
                        throw new IllegalArgumentException("BigDecimal too large to be encoded");
                    }
                    this.writeLong(decimal.unscaledValue().intValue());
                    continue;
                }
                if (value instanceof Date) {
                    this.writeOctet(84);
                    this.writeTimestamp((Date)value);
                    continue;
                }
                if (value instanceof Map) {
                    this.writeOctet(70);
                    this.writeTable((Map)value);
                    continue;
                }
                if (value instanceof Byte) {
                    this.writeOctet(98);
                    this.out.writeByte(((Byte)value).byteValue());
                    continue;
                }
                if (value instanceof Double) {
                    this.writeOctet(100);
                    this.out.writeDouble((Double)value);
                    continue;
                }
                if (value instanceof Float) {
                    this.writeOctet(102);
                    this.out.writeFloat(((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Long) {
                    this.writeOctet(108);
                    this.out.writeLong((Long)value);
                    continue;
                }
                if (value instanceof Short) {
                    this.writeOctet(115);
                    this.out.writeShort(((Short)value).shortValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    this.writeOctet(116);
                    this.out.writeBoolean((Boolean)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    this.writeOctet(120);
                    this.writeLong(((byte[])value).length);
                    this.out.write((byte[])value);
                    continue;
                }
                if (value == null) {
                    this.writeOctet(86);
                    continue;
                }
                throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName() + " for key " + entry.getKey());
            }
        }
    }

    public final void writeOctet(int octet) throws IOException {
        this.out.writeByte(octet);
    }

    public final void writeOctet(byte octet) throws IOException {
        this.out.writeByte(octet);
    }

    public final void writeTimestamp(Date timestamp) throws IOException {
        this.writeLonglong(timestamp.getTime() / 1000L);
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

